/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.BorderLine;
import com.groupdocs.cloud.signature.model.SignatureAppearance;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Describes appearance of PDF text annotation object (Title, Subject, Content).")
public class PdfTextAnnotationAppearance
extends SignatureAppearance {
    @SerializedName(value="border")
    private BorderLine border = null;
    @SerializedName(value="borderEffect")
    private BorderEffectEnum borderEffect = null;
    @SerializedName(value="borderEffectIntensity")
    private Integer borderEffectIntensity = null;
    @SerializedName(value="contents")
    private String contents = null;
    @SerializedName(value="hcornerRadius")
    private Integer hcornerRadius = null;
    @SerializedName(value="subject")
    private String subject = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="vcornerRadius")
    private Integer vcornerRadius = null;

    public PdfTextAnnotationAppearance border(BorderLine border) {
        this.border = border;
        return this;
    }

    @ApiModelProperty(value="Represents border appearance")
    public BorderLine getBorder() {
        return this.border;
    }

    public void setBorder(BorderLine border) {
        this.border = border;
    }

    public PdfTextAnnotationAppearance borderEffect(BorderEffectEnum borderEffect) {
        this.borderEffect = borderEffect;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets border effect.")
    public BorderEffectEnum getBorderEffect() {
        return this.borderEffect;
    }

    public void setBorderEffect(BorderEffectEnum borderEffect) {
        this.borderEffect = borderEffect;
    }

    public PdfTextAnnotationAppearance borderEffectIntensity(Integer borderEffectIntensity) {
        this.borderEffectIntensity = borderEffectIntensity;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets border effect intensity. Valid range of value is [0..2].")
    public Integer getBorderEffectIntensity() {
        return this.borderEffectIntensity;
    }

    public void setBorderEffectIntensity(Integer borderEffectIntensity) {
        this.borderEffectIntensity = borderEffectIntensity;
    }

    public PdfTextAnnotationAppearance contents(String contents) {
        this.contents = contents;
        return this;
    }

    @ApiModelProperty(value="Gets or sets content of annotation object.")
    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public PdfTextAnnotationAppearance hcornerRadius(Integer hcornerRadius) {
        this.hcornerRadius = hcornerRadius;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets horizontal corner radius.")
    public Integer getHcornerRadius() {
        return this.hcornerRadius;
    }

    public void setHcornerRadius(Integer hcornerRadius) {
        this.hcornerRadius = hcornerRadius;
    }

    public PdfTextAnnotationAppearance subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(value="Gets or sets Subject representing description of the object.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public PdfTextAnnotationAppearance title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a Title that will be displayed in title bar of annotation object.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public PdfTextAnnotationAppearance vcornerRadius(Integer vcornerRadius) {
        this.vcornerRadius = vcornerRadius;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets vertical corner radius.")
    public Integer getVcornerRadius() {
        return this.vcornerRadius;
    }

    public void setVcornerRadius(Integer vcornerRadius) {
        this.vcornerRadius = vcornerRadius;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfTextAnnotationAppearance pdfTextAnnotationAppearance = (PdfTextAnnotationAppearance)o;
        return Objects.equals(this.border, pdfTextAnnotationAppearance.border) && Objects.equals((Object)this.borderEffect, (Object)pdfTextAnnotationAppearance.borderEffect) && Objects.equals(this.borderEffectIntensity, pdfTextAnnotationAppearance.borderEffectIntensity) && Objects.equals(this.contents, pdfTextAnnotationAppearance.contents) && Objects.equals(this.hcornerRadius, pdfTextAnnotationAppearance.hcornerRadius) && Objects.equals(this.subject, pdfTextAnnotationAppearance.subject) && Objects.equals(this.title, pdfTextAnnotationAppearance.title) && Objects.equals(this.vcornerRadius, pdfTextAnnotationAppearance.vcornerRadius) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.border, this.borderEffect, this.borderEffectIntensity, this.contents, this.hcornerRadius, this.subject, this.title, this.vcornerRadius, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfTextAnnotationAppearance {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    border: ").append(this.toIndentedString(this.border)).append("\n");
        sb.append("    borderEffect: ").append(this.toIndentedString((Object)this.borderEffect)).append("\n");
        sb.append("    borderEffectIntensity: ").append(this.toIndentedString(this.borderEffectIntensity)).append("\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    hcornerRadius: ").append(this.toIndentedString(this.hcornerRadius)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    vcornerRadius: ").append(this.toIndentedString(this.vcornerRadius)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BorderEffectEnum {
        NONE("None"),
        CLOUDY("Cloudy");

        private String value;

        private BorderEffectEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BorderEffectEnum fromValue(String text) {
            for (BorderEffectEnum b : BorderEffectEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BorderEffectEnum> {
            public void write(JsonWriter jsonWriter, BorderEffectEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BorderEffectEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BorderEffectEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

