/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.SignatureAppearance;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Describes appearance of PDF text annotation sticker object and pop-up window of sticker.")
public class PdfTextStickerAppearance
extends SignatureAppearance {
    @SerializedName(value="contents")
    private String contents = null;
    @SerializedName(value="icon")
    private IconEnum icon = null;
    @SerializedName(value="opened")
    private Boolean opened = null;
    @SerializedName(value="subject")
    private String subject = null;
    @SerializedName(value="title")
    private String title = null;

    public PdfTextStickerAppearance contents(String contents) {
        this.contents = contents;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the contents of pop-up window.")
    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public PdfTextStickerAppearance icon(IconEnum icon) {
        this.icon = icon;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the icon of sticker.")
    public IconEnum getIcon() {
        return this.icon;
    }

    public void setIcon(IconEnum icon) {
        this.icon = icon;
    }

    public PdfTextStickerAppearance opened(Boolean opened) {
        this.opened = opened;
        return this;
    }

    @ApiModelProperty(required=true, value="Setup if sticker pop-up window will be opened by default.")
    public Boolean getOpened() {
        return this.opened;
    }

    public void setOpened(Boolean opened) {
        this.opened = opened;
    }

    public PdfTextStickerAppearance subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(value="Gets or sets subject.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public PdfTextStickerAppearance title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Gets or sets title of pop-up window.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfTextStickerAppearance pdfTextStickerAppearance = (PdfTextStickerAppearance)o;
        return Objects.equals(this.contents, pdfTextStickerAppearance.contents) && Objects.equals((Object)this.icon, (Object)pdfTextStickerAppearance.icon) && Objects.equals(this.opened, pdfTextStickerAppearance.opened) && Objects.equals(this.subject, pdfTextStickerAppearance.subject) && Objects.equals(this.title, pdfTextStickerAppearance.title) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.contents, this.icon, this.opened, this.subject, this.title, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfTextStickerAppearance {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString((Object)this.icon)).append("\n");
        sb.append("    opened: ").append(this.toIndentedString(this.opened)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IconEnum {
        NOTE("Note"),
        COMMENT("Comment"),
        KEY("Key"),
        HELP("Help"),
        NEWPARAGRAPH("NewParagraph"),
        PARAGRAPH("Paragraph"),
        INSERT("Insert"),
        CHECK("Check"),
        CROSS("Cross"),
        CIRCLE("Circle"),
        STAR("Star");

        private String value;

        private IconEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IconEnum fromValue(String text) {
            for (IconEnum b : IconEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<IconEnum> {
            public void write(JsonWriter jsonWriter, IconEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IconEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IconEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

