/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.BaseSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines preview request settings")
public class PreviewSettings
extends BaseSettings {
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="resolution")
    private Integer resolution = null;
    @SerializedName(value="pageNumbers")
    private List<Integer> pageNumbers = null;
    @SerializedName(value="previewFormat")
    private PreviewFormatEnum previewFormat = null;
    @SerializedName(value="hideSignatures")
    private Boolean hideSignatures = null;
    @SerializedName(value="outputPath")
    private String outputPath = null;

    public PreviewSettings width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Preview images width")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public PreviewSettings height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Preview images height")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public PreviewSettings resolution(Integer resolution) {
        this.resolution = resolution;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the resolution of the preview images in DPI (dots per inch).")
    public Integer getResolution() {
        return this.resolution;
    }

    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }

    public PreviewSettings pageNumbers(List<Integer> pageNumbers) {
        this.pageNumbers = pageNumbers;
        return this;
    }

    public PreviewSettings addPageNumbersItem(Integer pageNumbersItem) {
        if (this.pageNumbers == null) {
            this.pageNumbers = new ArrayList<Integer>();
        }
        this.pageNumbers.add(pageNumbersItem);
        return this;
    }

    @ApiModelProperty(value="Preview page numbers")
    public List<Integer> getPageNumbers() {
        return this.pageNumbers;
    }

    public void setPageNumbers(List<Integer> pageNumbers) {
        this.pageNumbers = pageNumbers;
    }

    public PreviewSettings previewFormat(PreviewFormatEnum previewFormat) {
        this.previewFormat = previewFormat;
        return this;
    }

    @ApiModelProperty(required=true, value="Preview format")
    public PreviewFormatEnum getPreviewFormat() {
        return this.previewFormat;
    }

    public void setPreviewFormat(PreviewFormatEnum previewFormat) {
        this.previewFormat = previewFormat;
    }

    public PreviewSettings hideSignatures(Boolean hideSignatures) {
        this.hideSignatures = hideSignatures;
        return this;
    }

    @ApiModelProperty(required=true, value="Flag to hide signatures from page preview image. Only signatures are marked as IsSignature will be hidden from generated document page image")
    public Boolean getHideSignatures() {
        return this.hideSignatures;
    }

    public void setHideSignatures(Boolean hideSignatures) {
        this.hideSignatures = hideSignatures;
    }

    public PreviewSettings outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @ApiModelProperty(value="Set path for output pages. If not set then default path used.")
    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreviewSettings previewSettings = (PreviewSettings)o;
        return Objects.equals(this.width, previewSettings.width) && Objects.equals(this.height, previewSettings.height) && Objects.equals(this.resolution, previewSettings.resolution) && Objects.equals(this.pageNumbers, previewSettings.pageNumbers) && Objects.equals((Object)this.previewFormat, (Object)previewSettings.previewFormat) && Objects.equals(this.hideSignatures, previewSettings.hideSignatures) && Objects.equals(this.outputPath, previewSettings.outputPath) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.width, this.height, this.resolution, this.pageNumbers, this.previewFormat, this.hideSignatures, this.outputPath, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PreviewSettings {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.resolution)).append("\n");
        sb.append("    pageNumbers: ").append(this.toIndentedString(this.pageNumbers)).append("\n");
        sb.append("    previewFormat: ").append(this.toIndentedString((Object)this.previewFormat)).append("\n");
        sb.append("    hideSignatures: ").append(this.toIndentedString(this.hideSignatures)).append("\n");
        sb.append("    outputPath: ").append(this.toIndentedString(this.outputPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PreviewFormatEnum {
        PNG("PNG"),
        JPEG("JPEG"),
        BMP("BMP");

        private String value;

        private PreviewFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PreviewFormatEnum fromValue(String text) {
            for (PreviewFormatEnum b : PreviewFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PreviewFormatEnum> {
            public void write(JsonWriter jsonWriter, PreviewFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PreviewFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PreviewFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

