/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.SearchOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Defines options to search QR-Code signature of document")
public class SearchQRCodeOptions
extends SearchOptions {
    @SerializedName(value="qrCodeType")
    private String qrCodeType = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="matchType")
    private MatchTypeEnum matchType = null;

    public SearchQRCodeOptions qrCodeType(String qrCodeType) {
        this.qrCodeType = qrCodeType;
        return this;
    }

    @ApiModelProperty(value="Specifies Encode Type property to search barcodes. If this value is not set, search is processed for all supported barcode types")
    public String getQrCodeType() {
        return this.qrCodeType;
    }

    public void setQrCodeType(String qrCodeType) {
        this.qrCodeType = qrCodeType;
    }

    public SearchQRCodeOptions text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Specifies text for searching and matching in barcode signature")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public SearchQRCodeOptions matchType(MatchTypeEnum matchType) {
        this.matchType = matchType;
        return this;
    }

    @ApiModelProperty(required=true, value="Get or set barcode text Match Type search. It is used only when Text property is set")
    public MatchTypeEnum getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchTypeEnum matchType) {
        this.matchType = matchType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchQRCodeOptions searchQRCodeOptions = (SearchQRCodeOptions)o;
        return Objects.equals(this.qrCodeType, searchQRCodeOptions.qrCodeType) && Objects.equals(this.text, searchQRCodeOptions.text) && Objects.equals((Object)this.matchType, (Object)searchQRCodeOptions.matchType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.qrCodeType, this.text, this.matchType, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchQRCodeOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    qrCodeType: ").append(this.toIndentedString(this.qrCodeType)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    matchType: ").append(this.toIndentedString((Object)this.matchType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MatchTypeEnum {
        EXACT("Exact"),
        STARTSWITH("StartsWith"),
        ENDSWITH("EndsWith"),
        CONTAINS("Contains");

        private String value;

        private MatchTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MatchTypeEnum fromValue(String text) {
            for (MatchTypeEnum b : MatchTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MatchTypeEnum> {
            public void write(JsonWriter jsonWriter, MatchTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MatchTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MatchTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

