/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.signature.model.BaseSettings;
import com.groupdocs.cloud.signature.model.SearchOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines signatures search settings request")
public class SearchSettings
extends BaseSettings {
    @SerializedName(value="options")
    private List<SearchOptions> options = null;

    public SearchSettings options(List<SearchOptions> options) {
        this.options = options;
        return this;
    }

    public SearchSettings addOptionsItem(SearchOptions optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<SearchOptions>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets options collection to perform search in a document")
    public List<SearchOptions> getOptions() {
        return this.options;
    }

    public void setOptions(List<SearchOptions> options) {
        this.options = options;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchSettings searchSettings = (SearchSettings)o;
        return Objects.equals(this.options, searchSettings.options) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.options, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchSettings {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

