/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.Padding;
import com.groupdocs.cloud.signature.model.SignTextOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Represents the Barcode signature options")
public class SignBarcodeOptions
extends SignTextOptions {
    @SerializedName(value="barcodeType")
    private String barcodeType = null;
    @SerializedName(value="transparency")
    private Double transparency = null;
    @SerializedName(value="codeTextAlignment")
    private CodeTextAlignmentEnum codeTextAlignment = null;
    @SerializedName(value="innerMargins")
    private Padding innerMargins = null;

    public SignBarcodeOptions barcodeType(String barcodeType) {
        this.barcodeType = barcodeType;
        return this;
    }

    @ApiModelProperty(value="Get or set Barcode type. Pick one from supported barcode types list")
    public String getBarcodeType() {
        return this.barcodeType;
    }

    public void setBarcodeType(String barcodeType) {
        this.barcodeType = barcodeType;
    }

    public SignBarcodeOptions transparency(Double transparency) {
        this.transparency = transparency;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the signature transparency (value from 0.0 (opaque) through 1.0 (clear)). Default value is 0 (opaque).")
    public Double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Double transparency) {
        this.transparency = transparency;
    }

    public SignBarcodeOptions codeTextAlignment(CodeTextAlignmentEnum codeTextAlignment) {
        this.codeTextAlignment = codeTextAlignment;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the alignment of text in the result Barcode Default value is None")
    public CodeTextAlignmentEnum getCodeTextAlignment() {
        return this.codeTextAlignment;
    }

    public void setCodeTextAlignment(CodeTextAlignmentEnum codeTextAlignment) {
        this.codeTextAlignment = codeTextAlignment;
    }

    public SignBarcodeOptions innerMargins(Padding innerMargins) {
        this.innerMargins = innerMargins;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the space between Barcode elements and result image borders")
    public Padding getInnerMargins() {
        return this.innerMargins;
    }

    public void setInnerMargins(Padding innerMargins) {
        this.innerMargins = innerMargins;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignBarcodeOptions signBarcodeOptions = (SignBarcodeOptions)o;
        return Objects.equals(this.barcodeType, signBarcodeOptions.barcodeType) && Objects.equals(this.transparency, signBarcodeOptions.transparency) && Objects.equals((Object)this.codeTextAlignment, (Object)signBarcodeOptions.codeTextAlignment) && Objects.equals(this.innerMargins, signBarcodeOptions.innerMargins) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.barcodeType, this.transparency, this.codeTextAlignment, this.innerMargins, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignBarcodeOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    barcodeType: ").append(this.toIndentedString(this.barcodeType)).append("\n");
        sb.append("    transparency: ").append(this.toIndentedString(this.transparency)).append("\n");
        sb.append("    codeTextAlignment: ").append(this.toIndentedString((Object)this.codeTextAlignment)).append("\n");
        sb.append("    innerMargins: ").append(this.toIndentedString(this.innerMargins)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CodeTextAlignmentEnum {
        NONE("None"),
        ABOVE("Above"),
        BELOW("Below"),
        RIGHT("Right");

        private String value;

        private CodeTextAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CodeTextAlignmentEnum fromValue(String text) {
            for (CodeTextAlignmentEnum b : CodeTextAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CodeTextAlignmentEnum> {
            public void write(JsonWriter jsonWriter, CodeTextAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CodeTextAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CodeTextAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

