/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.DigitalVBA;
import com.groupdocs.cloud.signature.model.SignImageOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Represents the Digital sign options")
public class SignDigitalOptions
extends SignImageOptions {
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="contact")
    private String contact = null;
    @SerializedName(value="location")
    private String location = null;
    @SerializedName(value="visible")
    private Boolean visible = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="certificateFilePath")
    private String certificateFilePath = null;
    @SerializedName(value="xadESType")
    private XadESTypeEnum xadESType = null;
    @SerializedName(value="digitalVBA")
    private DigitalVBA digitalVBA = null;
    @SerializedName(value="signTime")
    private OffsetDateTime signTime = null;
    @SerializedName(value="comments")
    private String comments = null;

    public SignDigitalOptions reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the reason of signature.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public SignDigitalOptions contact(String contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the signature contact.")
    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public SignDigitalOptions location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the signature location.")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public SignDigitalOptions visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the visibility of signature.")
    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public SignDigitalOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the password of digital certificate")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SignDigitalOptions certificateFilePath(String certificateFilePath) {
        this.certificateFilePath = certificateFilePath;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the digital certificate file GUID")
    public String getCertificateFilePath() {
        return this.certificateFilePath;
    }

    public void setCertificateFilePath(String certificateFilePath) {
        this.certificateFilePath = certificateFilePath;
    }

    public SignDigitalOptions xadESType(XadESTypeEnum xadESType) {
        this.xadESType = xadESType;
        return this;
    }

    @ApiModelProperty(required=true, value="XAdES type GroupDocs.Signature.Options.DigitalSignOptions.XAdESType. Default value is None (XAdES is off). At this moment XAdES signature type is supported only for Spreadsheet documents.             ")
    public XadESTypeEnum getXadESType() {
        return this.xadESType;
    }

    public void setXadESType(XadESTypeEnum xadESType) {
        this.xadESType = xadESType;
    }

    public SignDigitalOptions digitalVBA(DigitalVBA digitalVBA) {
        this.digitalVBA = digitalVBA;
        return this;
    }

    @ApiModelProperty(value="Options for signing VBA project")
    public DigitalVBA getDigitalVBA() {
        return this.digitalVBA;
    }

    public void setDigitalVBA(DigitalVBA digitalVBA) {
        this.digitalVBA = digitalVBA;
    }

    public SignDigitalOptions signTime(OffsetDateTime signTime) {
        this.signTime = signTime;
        return this;
    }

    @ApiModelProperty(value="The time the document was signed.")
    public OffsetDateTime getSignTime() {
        return this.signTime;
    }

    public void setSignTime(OffsetDateTime signTime) {
        this.signTime = signTime;
    }

    public SignDigitalOptions comments(String comments) {
        this.comments = comments;
        return this;
    }

    @ApiModelProperty(value="The signing purpose comment.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignDigitalOptions signDigitalOptions = (SignDigitalOptions)o;
        return Objects.equals(this.reason, signDigitalOptions.reason) && Objects.equals(this.contact, signDigitalOptions.contact) && Objects.equals(this.location, signDigitalOptions.location) && Objects.equals(this.visible, signDigitalOptions.visible) && Objects.equals(this.password, signDigitalOptions.password) && Objects.equals(this.certificateFilePath, signDigitalOptions.certificateFilePath) && Objects.equals((Object)this.xadESType, (Object)signDigitalOptions.xadESType) && Objects.equals(this.digitalVBA, signDigitalOptions.digitalVBA) && Objects.equals(this.signTime, signDigitalOptions.signTime) && Objects.equals(this.comments, signDigitalOptions.comments) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.contact, this.location, this.visible, this.password, this.certificateFilePath, this.xadESType, this.digitalVBA, this.signTime, this.comments, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignDigitalOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    certificateFilePath: ").append(this.toIndentedString(this.certificateFilePath)).append("\n");
        sb.append("    xadESType: ").append(this.toIndentedString((Object)this.xadESType)).append("\n");
        sb.append("    digitalVBA: ").append(this.toIndentedString(this.digitalVBA)).append("\n");
        sb.append("    signTime: ").append(this.toIndentedString(this.signTime)).append("\n");
        sb.append("    comments: ").append(this.toIndentedString(this.comments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum XadESTypeEnum {
        NONE("None"),
        XADES("XAdES");

        private String value;

        private XadESTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static XadESTypeEnum fromValue(String text) {
            for (XadESTypeEnum b : XadESTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<XadESTypeEnum> {
            public void write(JsonWriter jsonWriter, XadESTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public XadESTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return XadESTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

