/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.BorderLine;
import com.groupdocs.cloud.signature.model.Padding;
import com.groupdocs.cloud.signature.model.SignOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Represents the Image sign options")
public class SignImageOptions
extends SignOptions {
    @SerializedName(value="imageFilePath")
    private String imageFilePath = null;
    @SerializedName(value="left")
    private Integer left = null;
    @SerializedName(value="top")
    private Integer top = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="locationMeasureType")
    private LocationMeasureTypeEnum locationMeasureType = null;
    @SerializedName(value="sizeMeasureType")
    private SizeMeasureTypeEnum sizeMeasureType = null;
    @SerializedName(value="rotationAngle")
    private Integer rotationAngle = null;
    @SerializedName(value="horizontalAlignment")
    private HorizontalAlignmentEnum horizontalAlignment = null;
    @SerializedName(value="verticalAlignment")
    private VerticalAlignmentEnum verticalAlignment = null;
    @SerializedName(value="margin")
    private Padding margin = null;
    @SerializedName(value="marginMeasureType")
    private MarginMeasureTypeEnum marginMeasureType = null;
    @SerializedName(value="transparency")
    private Double transparency = null;
    @SerializedName(value="border")
    private BorderLine border = null;

    public SignImageOptions imageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the signature image file name. This property is used only if ImageStream is not specified")
    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public SignImageOptions left(Integer left) {
        this.left = left;
        return this;
    }

    @ApiModelProperty(required=true, value="Left X position of Signature on Document Page in Measure values (pixels or percent see MeasureType LocationMeasureType). (works if horizontal alignment is not specified). For Spreadsheet documents this property is mutually exclusive with Column property. If Left property is set ColumnNumber will be reset to 0")
    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public SignImageOptions top(Integer top) {
        this.top = top;
        return this;
    }

    @ApiModelProperty(required=true, value="Top Y Position of Signature on Document Page in Measure values (pixels or percent see MeasureType LocationMeasureType). (works if vertical alignment is not specified). For Spreadsheet documents this property is mutually exclusive with Row property. If Top property is set RowNumber will be reset to 0")
    public Integer getTop() {
        return this.top;
    }

    public void setTop(Integer top) {
        this.top = top;
    }

    public SignImageOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Width of Signature on Document Page in Measure values (pixels or percent see MeasureType SizeMeasureType)")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public SignImageOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Height of Signature on Document Page in Measure values (pixels or percent see MeasureType SizeMeasureType)")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public SignImageOptions locationMeasureType(LocationMeasureTypeEnum locationMeasureType) {
        this.locationMeasureType = locationMeasureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Measure type (pixels or percent) for Left and Top properties")
    public LocationMeasureTypeEnum getLocationMeasureType() {
        return this.locationMeasureType;
    }

    public void setLocationMeasureType(LocationMeasureTypeEnum locationMeasureType) {
        this.locationMeasureType = locationMeasureType;
    }

    public SignImageOptions sizeMeasureType(SizeMeasureTypeEnum sizeMeasureType) {
        this.sizeMeasureType = sizeMeasureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Measure type (pixels or percent) for Width and Height properties")
    public SizeMeasureTypeEnum getSizeMeasureType() {
        return this.sizeMeasureType;
    }

    public void setSizeMeasureType(SizeMeasureTypeEnum sizeMeasureType) {
        this.sizeMeasureType = sizeMeasureType;
    }

    public SignImageOptions rotationAngle(Integer rotationAngle) {
        this.rotationAngle = rotationAngle;
        return this;
    }

    @ApiModelProperty(required=true, value="Rotation angle of signature on document page (clockwise)")
    public Integer getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(Integer rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public SignImageOptions horizontalAlignment(HorizontalAlignmentEnum horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @ApiModelProperty(required=true, value="Horizontal alignment of signature on document page")
    public HorizontalAlignmentEnum getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignmentEnum horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public SignImageOptions verticalAlignment(VerticalAlignmentEnum verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(required=true, value="Vertical alignment of signature on document page")
    public VerticalAlignmentEnum getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignmentEnum verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public SignImageOptions margin(Padding margin) {
        this.margin = margin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the space between Sign and Document edges (works ONLY if horizontal or vertical alignment are specified)")
    public Padding getMargin() {
        return this.margin;
    }

    public void setMargin(Padding margin) {
        this.margin = margin;
    }

    public SignImageOptions marginMeasureType(MarginMeasureTypeEnum marginMeasureType) {
        this.marginMeasureType = marginMeasureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the measure type (pixels or percent) for Margin")
    public MarginMeasureTypeEnum getMarginMeasureType() {
        return this.marginMeasureType;
    }

    public void setMarginMeasureType(MarginMeasureTypeEnum marginMeasureType) {
        this.marginMeasureType = marginMeasureType;
    }

    public SignImageOptions transparency(Double transparency) {
        this.transparency = transparency;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the signature transparency(value from 0.0 (opaque) through 1.0 (clear)). Default value is 0 (opaque).")
    public Double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Double transparency) {
        this.transparency = transparency;
    }

    public SignImageOptions border(BorderLine border) {
        this.border = border;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the signature border properties")
    public BorderLine getBorder() {
        return this.border;
    }

    public void setBorder(BorderLine border) {
        this.border = border;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignImageOptions signImageOptions = (SignImageOptions)o;
        return Objects.equals(this.imageFilePath, signImageOptions.imageFilePath) && Objects.equals(this.left, signImageOptions.left) && Objects.equals(this.top, signImageOptions.top) && Objects.equals(this.width, signImageOptions.width) && Objects.equals(this.height, signImageOptions.height) && Objects.equals((Object)this.locationMeasureType, (Object)signImageOptions.locationMeasureType) && Objects.equals((Object)this.sizeMeasureType, (Object)signImageOptions.sizeMeasureType) && Objects.equals(this.rotationAngle, signImageOptions.rotationAngle) && Objects.equals((Object)this.horizontalAlignment, (Object)signImageOptions.horizontalAlignment) && Objects.equals((Object)this.verticalAlignment, (Object)signImageOptions.verticalAlignment) && Objects.equals(this.margin, signImageOptions.margin) && Objects.equals((Object)this.marginMeasureType, (Object)signImageOptions.marginMeasureType) && Objects.equals(this.transparency, signImageOptions.transparency) && Objects.equals(this.border, signImageOptions.border) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.imageFilePath, this.left, this.top, this.width, this.height, this.locationMeasureType, this.sizeMeasureType, this.rotationAngle, this.horizontalAlignment, this.verticalAlignment, this.margin, this.marginMeasureType, this.transparency, this.border, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignImageOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    imageFilePath: ").append(this.toIndentedString(this.imageFilePath)).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.left)).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    locationMeasureType: ").append(this.toIndentedString((Object)this.locationMeasureType)).append("\n");
        sb.append("    sizeMeasureType: ").append(this.toIndentedString((Object)this.sizeMeasureType)).append("\n");
        sb.append("    rotationAngle: ").append(this.toIndentedString(this.rotationAngle)).append("\n");
        sb.append("    horizontalAlignment: ").append(this.toIndentedString((Object)this.horizontalAlignment)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("    margin: ").append(this.toIndentedString(this.margin)).append("\n");
        sb.append("    marginMeasureType: ").append(this.toIndentedString((Object)this.marginMeasureType)).append("\n");
        sb.append("    transparency: ").append(this.toIndentedString(this.transparency)).append("\n");
        sb.append("    border: ").append(this.toIndentedString(this.border)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MarginMeasureTypeEnum {
        PIXELS("Pixels"),
        PERCENTS("Percents"),
        MILLIMETERS("Millimeters");

        private String value;

        private MarginMeasureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MarginMeasureTypeEnum fromValue(String text) {
            for (MarginMeasureTypeEnum b : MarginMeasureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MarginMeasureTypeEnum> {
            public void write(JsonWriter jsonWriter, MarginMeasureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MarginMeasureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MarginMeasureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerticalAlignmentEnum {
        NONE("None"),
        TOP("Top"),
        CENTER("Center"),
        BOTTOM("Bottom");

        private String value;

        private VerticalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerticalAlignmentEnum fromValue(String text) {
            for (VerticalAlignmentEnum b : VerticalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerticalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, VerticalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerticalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerticalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HorizontalAlignmentEnum {
        NONE("None"),
        LEFT("Left"),
        CENTER("Center"),
        RIGHT("Right");

        private String value;

        private HorizontalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HorizontalAlignmentEnum fromValue(String text) {
            for (HorizontalAlignmentEnum b : HorizontalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HorizontalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, HorizontalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HorizontalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HorizontalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SizeMeasureTypeEnum {
        PIXELS("Pixels"),
        PERCENTS("Percents"),
        MILLIMETERS("Millimeters");

        private String value;

        private SizeMeasureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SizeMeasureTypeEnum fromValue(String text) {
            for (SizeMeasureTypeEnum b : SizeMeasureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SizeMeasureTypeEnum> {
            public void write(JsonWriter jsonWriter, SizeMeasureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SizeMeasureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SizeMeasureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LocationMeasureTypeEnum {
        PIXELS("Pixels"),
        PERCENTS("Percents"),
        MILLIMETERS("Millimeters");

        private String value;

        private LocationMeasureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LocationMeasureTypeEnum fromValue(String text) {
            for (LocationMeasureTypeEnum b : LocationMeasureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LocationMeasureTypeEnum> {
            public void write(JsonWriter jsonWriter, LocationMeasureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LocationMeasureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LocationMeasureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

