/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.Padding;
import com.groupdocs.cloud.signature.model.SignTextOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Represents the QR-code signature options")
public class SignQRCodeOptions
extends SignTextOptions {
    @SerializedName(value="qrCodeType")
    private String qrCodeType = null;
    @SerializedName(value="transparency")
    private Double transparency = null;
    @SerializedName(value="codeTextAlignment")
    private CodeTextAlignmentEnum codeTextAlignment = null;
    @SerializedName(value="innerMargins")
    private Padding innerMargins = null;
    @SerializedName(value="logoFilePath")
    private String logoFilePath = null;

    public SignQRCodeOptions qrCodeType(String qrCodeType) {
        this.qrCodeType = qrCodeType;
        return this;
    }

    @ApiModelProperty(value="Get or set QRCode type. Value should be one from supported QRCode types list")
    public String getQrCodeType() {
        return this.qrCodeType;
    }

    public void setQrCodeType(String qrCodeType) {
        this.qrCodeType = qrCodeType;
    }

    public SignQRCodeOptions transparency(Double transparency) {
        this.transparency = transparency;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the signature transparency (value from 0.0 (opaque) through 1.0 (clear)). Default value is 0 (opaque).             ")
    public Double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Double transparency) {
        this.transparency = transparency;
    }

    public SignQRCodeOptions codeTextAlignment(CodeTextAlignmentEnum codeTextAlignment) {
        this.codeTextAlignment = codeTextAlignment;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the alignment of text in the result QR-code Default value is None")
    public CodeTextAlignmentEnum getCodeTextAlignment() {
        return this.codeTextAlignment;
    }

    public void setCodeTextAlignment(CodeTextAlignmentEnum codeTextAlignment) {
        this.codeTextAlignment = codeTextAlignment;
    }

    public SignQRCodeOptions innerMargins(Padding innerMargins) {
        this.innerMargins = innerMargins;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the space between QRCode elements and result image borders")
    public Padding getInnerMargins() {
        return this.innerMargins;
    }

    public void setInnerMargins(Padding innerMargins) {
        this.innerMargins = innerMargins;
    }

    public SignQRCodeOptions logoFilePath(String logoFilePath) {
        this.logoFilePath = logoFilePath;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the QR-code logo image file name. This property in use only if LogoStream is not specified. Using of this property could cause problems with verification. Use it carefully")
    public String getLogoFilePath() {
        return this.logoFilePath;
    }

    public void setLogoFilePath(String logoFilePath) {
        this.logoFilePath = logoFilePath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignQRCodeOptions signQRCodeOptions = (SignQRCodeOptions)o;
        return Objects.equals(this.qrCodeType, signQRCodeOptions.qrCodeType) && Objects.equals(this.transparency, signQRCodeOptions.transparency) && Objects.equals((Object)this.codeTextAlignment, (Object)signQRCodeOptions.codeTextAlignment) && Objects.equals(this.innerMargins, signQRCodeOptions.innerMargins) && Objects.equals(this.logoFilePath, signQRCodeOptions.logoFilePath) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.qrCodeType, this.transparency, this.codeTextAlignment, this.innerMargins, this.logoFilePath, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignQRCodeOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    qrCodeType: ").append(this.toIndentedString(this.qrCodeType)).append("\n");
        sb.append("    transparency: ").append(this.toIndentedString(this.transparency)).append("\n");
        sb.append("    codeTextAlignment: ").append(this.toIndentedString((Object)this.codeTextAlignment)).append("\n");
        sb.append("    innerMargins: ").append(this.toIndentedString(this.innerMargins)).append("\n");
        sb.append("    logoFilePath: ").append(this.toIndentedString(this.logoFilePath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CodeTextAlignmentEnum {
        NONE("None"),
        ABOVE("Above"),
        BELOW("Below"),
        RIGHT("Right");

        private String value;

        private CodeTextAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CodeTextAlignmentEnum fromValue(String text) {
            for (CodeTextAlignmentEnum b : CodeTextAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CodeTextAlignmentEnum> {
            public void write(JsonWriter jsonWriter, CodeTextAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CodeTextAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CodeTextAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

