/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.signature.model.FileInfo;
import com.groupdocs.cloud.signature.model.Signature;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Sign result information")
public class SignResult {
    @SerializedName(value="fileInfo")
    private FileInfo fileInfo = null;
    @SerializedName(value="size")
    private Long size = null;
    @SerializedName(value="downloadUrl")
    private String downloadUrl = null;
    @SerializedName(value="succeeded")
    private List<Signature> succeeded = null;
    @SerializedName(value="failed")
    private List<Signature> failed = null;

    public SignResult fileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }

    @ApiModelProperty(value="Signed file info")
    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public SignResult size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="Source document size in bytes")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public SignResult downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(value="ULR to retrieve signed file")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public SignResult succeeded(List<Signature> succeeded) {
        this.succeeded = succeeded;
        return this;
    }

    public SignResult addSucceededItem(Signature succeededItem) {
        if (this.succeeded == null) {
            this.succeeded = new ArrayList<Signature>();
        }
        this.succeeded.add(succeededItem);
        return this;
    }

    @ApiModelProperty(value="List of newly created signatures")
    public List<Signature> getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(List<Signature> succeeded) {
        this.succeeded = succeeded;
    }

    public SignResult failed(List<Signature> failed) {
        this.failed = failed;
        return this;
    }

    public SignResult addFailedItem(Signature failedItem) {
        if (this.failed == null) {
            this.failed = new ArrayList<Signature>();
        }
        this.failed.add(failedItem);
        return this;
    }

    @ApiModelProperty(value="List of signatures that were failed to create")
    public List<Signature> getFailed() {
        return this.failed;
    }

    public void setFailed(List<Signature> failed) {
        this.failed = failed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignResult signResult = (SignResult)o;
        return Objects.equals(this.fileInfo, signResult.fileInfo) && Objects.equals(this.size, signResult.size) && Objects.equals(this.downloadUrl, signResult.downloadUrl) && Objects.equals(this.succeeded, signResult.succeeded) && Objects.equals(this.failed, signResult.failed);
    }

    public int hashCode() {
        return Objects.hash(this.fileInfo, this.size, this.downloadUrl, this.succeeded, this.failed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignResult {\n");
        sb.append("    fileInfo: ").append(this.toIndentedString(this.fileInfo)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    succeeded: ").append(this.toIndentedString(this.succeeded)).append("\n");
        sb.append("    failed: ").append(this.toIndentedString(this.failed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

