/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.signature.model.BaseSettings;
import com.groupdocs.cloud.signature.model.SaveOptions;
import com.groupdocs.cloud.signature.model.SignOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines sign document settings request")
public class SignSettings
extends BaseSettings {
    @SerializedName(value="options")
    private List<SignOptions> options = null;
    @SerializedName(value="saveOptions")
    private SaveOptions saveOptions = null;

    public SignSettings options(List<SignOptions> options) {
        this.options = options;
        return this;
    }

    public SignSettings addOptionsItem(SignOptions optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<SignOptions>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets options to perform document signing")
    public List<SignOptions> getOptions() {
        return this.options;
    }

    public void setOptions(List<SignOptions> options) {
        this.options = options;
    }

    public SignSettings saveOptions(SaveOptions saveOptions) {
        this.saveOptions = saveOptions;
        return this;
    }

    @ApiModelProperty(value="Gets or sets format specific save options for output file")
    public SaveOptions getSaveOptions() {
        return this.saveOptions;
    }

    public void setSaveOptions(SaveOptions saveOptions) {
        this.saveOptions = saveOptions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignSettings signSettings = (SignSettings)o;
        return Objects.equals(this.options, signSettings.options) && Objects.equals(this.saveOptions, signSettings.saveOptions) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.options, this.saveOptions, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignSettings {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    saveOptions: ").append(this.toIndentedString(this.saveOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

