/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.Brush;
import com.groupdocs.cloud.signature.model.Color;
import com.groupdocs.cloud.signature.model.SignImageOptions;
import com.groupdocs.cloud.signature.model.StampLine;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents the Stamp signature options")
public class SignStampOptions
extends SignImageOptions {
    @SerializedName(value="outerLines")
    private List<StampLine> outerLines = null;
    @SerializedName(value="innerLines")
    private List<StampLine> innerLines = null;
    @SerializedName(value="backgroundColor")
    private Color backgroundColor = null;
    @SerializedName(value="backgroundBrush")
    private Brush backgroundBrush = null;
    @SerializedName(value="backgroundColorCropType")
    private BackgroundColorCropTypeEnum backgroundColorCropType = null;
    @SerializedName(value="backgroundImageCropType")
    private BackgroundImageCropTypeEnum backgroundImageCropType = null;

    public SignStampOptions outerLines(List<StampLine> outerLines) {
        this.outerLines = outerLines;
        return this;
    }

    public SignStampOptions addOuterLinesItem(StampLine outerLinesItem) {
        if (this.outerLines == null) {
            this.outerLines = new ArrayList<StampLine>();
        }
        this.outerLines.add(outerLinesItem);
        return this;
    }

    @ApiModelProperty(value="List of Outer Lines rendered as concentric circles")
    public List<StampLine> getOuterLines() {
        return this.outerLines;
    }

    public void setOuterLines(List<StampLine> outerLines) {
        this.outerLines = outerLines;
    }

    public SignStampOptions innerLines(List<StampLine> innerLines) {
        this.innerLines = innerLines;
        return this;
    }

    public SignStampOptions addInnerLinesItem(StampLine innerLinesItem) {
        if (this.innerLines == null) {
            this.innerLines = new ArrayList<StampLine>();
        }
        this.innerLines.add(innerLinesItem);
        return this;
    }

    @ApiModelProperty(value="List of Inner Lines rendered as set of rectangles")
    public List<StampLine> getInnerLines() {
        return this.innerLines;
    }

    public void setInnerLines(List<StampLine> innerLines) {
        this.innerLines = innerLines;
    }

    public SignStampOptions backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the background color of signature")
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public SignStampOptions backgroundBrush(Brush backgroundBrush) {
        this.backgroundBrush = backgroundBrush;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the signature background brush. Value by default is null.  When property has a value it is used instead BackgroundBrush property")
    public Brush getBackgroundBrush() {
        return this.backgroundBrush;
    }

    public void setBackgroundBrush(Brush backgroundBrush) {
        this.backgroundBrush = backgroundBrush;
    }

    public SignStampOptions backgroundColorCropType(BackgroundColorCropTypeEnum backgroundColorCropType) {
        this.backgroundColorCropType = backgroundColorCropType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the background color crop type of signature")
    public BackgroundColorCropTypeEnum getBackgroundColorCropType() {
        return this.backgroundColorCropType;
    }

    public void setBackgroundColorCropType(BackgroundColorCropTypeEnum backgroundColorCropType) {
        this.backgroundColorCropType = backgroundColorCropType;
    }

    public SignStampOptions backgroundImageCropType(BackgroundImageCropTypeEnum backgroundImageCropType) {
        this.backgroundImageCropType = backgroundImageCropType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the background image crop type of signature")
    public BackgroundImageCropTypeEnum getBackgroundImageCropType() {
        return this.backgroundImageCropType;
    }

    public void setBackgroundImageCropType(BackgroundImageCropTypeEnum backgroundImageCropType) {
        this.backgroundImageCropType = backgroundImageCropType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignStampOptions signStampOptions = (SignStampOptions)o;
        return Objects.equals(this.outerLines, signStampOptions.outerLines) && Objects.equals(this.innerLines, signStampOptions.innerLines) && Objects.equals(this.backgroundColor, signStampOptions.backgroundColor) && Objects.equals(this.backgroundBrush, signStampOptions.backgroundBrush) && Objects.equals((Object)this.backgroundColorCropType, (Object)signStampOptions.backgroundColorCropType) && Objects.equals((Object)this.backgroundImageCropType, (Object)signStampOptions.backgroundImageCropType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.outerLines, this.innerLines, this.backgroundColor, this.backgroundBrush, this.backgroundColorCropType, this.backgroundImageCropType, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignStampOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    outerLines: ").append(this.toIndentedString(this.outerLines)).append("\n");
        sb.append("    innerLines: ").append(this.toIndentedString(this.innerLines)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    backgroundBrush: ").append(this.toIndentedString(this.backgroundBrush)).append("\n");
        sb.append("    backgroundColorCropType: ").append(this.toIndentedString((Object)this.backgroundColorCropType)).append("\n");
        sb.append("    backgroundImageCropType: ").append(this.toIndentedString((Object)this.backgroundImageCropType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BackgroundImageCropTypeEnum {
        NONE("None"),
        OUTERAREA("OuterArea"),
        MIDDLEAREA("MiddleArea"),
        INNERAREA("InnerArea");

        private String value;

        private BackgroundImageCropTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BackgroundImageCropTypeEnum fromValue(String text) {
            for (BackgroundImageCropTypeEnum b : BackgroundImageCropTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BackgroundImageCropTypeEnum> {
            public void write(JsonWriter jsonWriter, BackgroundImageCropTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BackgroundImageCropTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BackgroundImageCropTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BackgroundColorCropTypeEnum {
        NONE("None"),
        OUTERAREA("OuterArea"),
        MIDDLEAREA("MiddleArea"),
        INNERAREA("InnerArea");

        private String value;

        private BackgroundColorCropTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BackgroundColorCropTypeEnum fromValue(String text) {
            for (BackgroundColorCropTypeEnum b : BackgroundColorCropTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BackgroundColorCropTypeEnum> {
            public void write(JsonWriter jsonWriter, BackgroundColorCropTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BackgroundColorCropTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BackgroundColorCropTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

