/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.BorderLine;
import com.groupdocs.cloud.signature.model.Brush;
import com.groupdocs.cloud.signature.model.Color;
import com.groupdocs.cloud.signature.model.Padding;
import com.groupdocs.cloud.signature.model.SignOptions;
import com.groupdocs.cloud.signature.model.SignatureFont;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Base container class for signature options data")
public class SignTextOptions
extends SignOptions {
    @SerializedName(value="left")
    private Integer left = null;
    @SerializedName(value="top")
    private Integer top = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="locationMeasureType")
    private LocationMeasureTypeEnum locationMeasureType = null;
    @SerializedName(value="sizeMeasureType")
    private SizeMeasureTypeEnum sizeMeasureType = null;
    @SerializedName(value="stretch")
    private StretchEnum stretch = null;
    @SerializedName(value="rotationAngle")
    private Integer rotationAngle = null;
    @SerializedName(value="horizontalAlignment")
    private HorizontalAlignmentEnum horizontalAlignment = null;
    @SerializedName(value="verticalAlignment")
    private VerticalAlignmentEnum verticalAlignment = null;
    @SerializedName(value="margin")
    private Padding margin = null;
    @SerializedName(value="marginMeasureType")
    private MarginMeasureTypeEnum marginMeasureType = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="font")
    private SignatureFont font = null;
    @SerializedName(value="foreColor")
    private Color foreColor = null;
    @SerializedName(value="backgroundColor")
    private Color backgroundColor = null;
    @SerializedName(value="backgroundBrush")
    private Brush backgroundBrush = null;
    @SerializedName(value="border")
    private BorderLine border = null;
    @SerializedName(value="textHorizontalAlignment")
    private TextHorizontalAlignmentEnum textHorizontalAlignment = null;
    @SerializedName(value="textVerticalAlignment")
    private TextVerticalAlignmentEnum textVerticalAlignment = null;
    @SerializedName(value="zorder")
    private Integer zorder = null;
    @SerializedName(value="_native")
    private Boolean _native = null;

    public SignTextOptions left(Integer left) {
        this.left = left;
        return this;
    }

    @ApiModelProperty(required=true, value="Left X position of Signature on Document Page in Measure values (pixels or percent see MeasureType LocationMeasureType property)")
    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public SignTextOptions top(Integer top) {
        this.top = top;
        return this;
    }

    @ApiModelProperty(required=true, value="Top Y Position of Signature on Document Page in Measure values (pixels or percent see MeasureType LocationMeasureType property)")
    public Integer getTop() {
        return this.top;
    }

    public void setTop(Integer top) {
        this.top = top;
    }

    public SignTextOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Width of Signature area on Document Page in Measure values (pixels or percent see MeasureType SizeMeasureType property)")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public SignTextOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Height of Signature are on Document Page in Measure values (pixels or percent see MeasureType SizeMeasureType property)")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public SignTextOptions locationMeasureType(LocationMeasureTypeEnum locationMeasureType) {
        this.locationMeasureType = locationMeasureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Measure type (pixels or percent) for Left and Top properties")
    public LocationMeasureTypeEnum getLocationMeasureType() {
        return this.locationMeasureType;
    }

    public void setLocationMeasureType(LocationMeasureTypeEnum locationMeasureType) {
        this.locationMeasureType = locationMeasureType;
    }

    public SignTextOptions sizeMeasureType(SizeMeasureTypeEnum sizeMeasureType) {
        this.sizeMeasureType = sizeMeasureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Measure type (pixels or percent) for Width and Height properties")
    public SizeMeasureTypeEnum getSizeMeasureType() {
        return this.sizeMeasureType;
    }

    public void setSizeMeasureType(SizeMeasureTypeEnum sizeMeasureType) {
        this.sizeMeasureType = sizeMeasureType;
    }

    public SignTextOptions stretch(StretchEnum stretch) {
        this.stretch = stretch;
        return this;
    }

    @ApiModelProperty(required=true, value="Stretch mode on document page")
    public StretchEnum getStretch() {
        return this.stretch;
    }

    public void setStretch(StretchEnum stretch) {
        this.stretch = stretch;
    }

    public SignTextOptions rotationAngle(Integer rotationAngle) {
        this.rotationAngle = rotationAngle;
        return this;
    }

    @ApiModelProperty(required=true, value="Rotation angle of signature on document page (clockwise)")
    public Integer getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(Integer rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public SignTextOptions horizontalAlignment(HorizontalAlignmentEnum horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @ApiModelProperty(required=true, value="Horizontal alignment of signature on document page")
    public HorizontalAlignmentEnum getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignmentEnum horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public SignTextOptions verticalAlignment(VerticalAlignmentEnum verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(required=true, value="Vertical alignment of signature on document page")
    public VerticalAlignmentEnum getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignmentEnum verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public SignTextOptions margin(Padding margin) {
        this.margin = margin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the space between Sign and Document edges (works ONLY if horizontal or vertical alignment are specified)")
    public Padding getMargin() {
        return this.margin;
    }

    public void setMargin(Padding margin) {
        this.margin = margin;
    }

    public SignTextOptions marginMeasureType(MarginMeasureTypeEnum marginMeasureType) {
        this.marginMeasureType = marginMeasureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the measure type (pixels or percent) for Margin")
    public MarginMeasureTypeEnum getMarginMeasureType() {
        return this.marginMeasureType;
    }

    public void setMarginMeasureType(MarginMeasureTypeEnum marginMeasureType) {
        this.marginMeasureType = marginMeasureType;
    }

    public SignTextOptions text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Text of signature")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public SignTextOptions font(SignatureFont font) {
        this.font = font;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the font of signature")
    public SignatureFont getFont() {
        return this.font;
    }

    public void setFont(SignatureFont font) {
        this.font = font;
    }

    public SignTextOptions foreColor(Color foreColor) {
        this.foreColor = foreColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the fore color of signature")
    public Color getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(Color foreColor) {
        this.foreColor = foreColor;
    }

    public SignTextOptions backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the background color of signature")
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public SignTextOptions backgroundBrush(Brush backgroundBrush) {
        this.backgroundBrush = backgroundBrush;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the signature background brush. Value by default is null.  If this property has a value it will be used instead BackgroundBrush property. For Spreadsheet documents TextStamp implementation RadialGradientBrush is not applicable, it is replaced by LinearGradientBrush. Spreadsheets, Images, Presentations It is not used for Watermark implementation. PDF For Stamp implementation LinearGradientBrush (ColorStart) and RadialGradientBrush (ColorInner) are used as SolidBrush. PDF It is not used for Annotation, Sticker, TextToFormField and Watermark implementations. Presentations For TextStamp implementation RadialGradientBrush is not applicable, it is replaced by LinearGradientBrush. Word Processing For TextStamp implementation LinearGradientBrush (ColorStart) and RadialGradientBrush (ColorInner) are used as SolidBrush. Word Processing It is not used for TextToFormField and Watermark implementations")
    public Brush getBackgroundBrush() {
        return this.backgroundBrush;
    }

    public void setBackgroundBrush(Brush backgroundBrush) {
        this.backgroundBrush = backgroundBrush;
    }

    public SignTextOptions border(BorderLine border) {
        this.border = border;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the signature border properties")
    public BorderLine getBorder() {
        return this.border;
    }

    public void setBorder(BorderLine border) {
        this.border = border;
    }

    public SignTextOptions textHorizontalAlignment(TextHorizontalAlignmentEnum textHorizontalAlignment) {
        this.textHorizontalAlignment = textHorizontalAlignment;
        return this;
    }

    @ApiModelProperty(required=true, value="Horizontal alignment of text inside a signature")
    public TextHorizontalAlignmentEnum getTextHorizontalAlignment() {
        return this.textHorizontalAlignment;
    }

    public void setTextHorizontalAlignment(TextHorizontalAlignmentEnum textHorizontalAlignment) {
        this.textHorizontalAlignment = textHorizontalAlignment;
    }

    public SignTextOptions textVerticalAlignment(TextVerticalAlignmentEnum textVerticalAlignment) {
        this.textVerticalAlignment = textVerticalAlignment;
        return this;
    }

    @ApiModelProperty(required=true, value="Vertical alignment of text inside a signature")
    public TextVerticalAlignmentEnum getTextVerticalAlignment() {
        return this.textVerticalAlignment;
    }

    public void setTextVerticalAlignment(TextVerticalAlignmentEnum textVerticalAlignment) {
        this.textVerticalAlignment = textVerticalAlignment;
    }

    public SignTextOptions zorder(Integer zorder) {
        this.zorder = zorder;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the Z-order position of text signature. Determines the display order of overlapping signatures.             ")
    public Integer getZorder() {
        return this.zorder;
    }

    public void setZorder(Integer zorder) {
        this.zorder = zorder;
    }

    public SignTextOptions _native(Boolean _native) {
        this._native = _native;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the native attribute. If it is set document specific signatures could be used. Native text watermark for WordProcessing documents is different than regular, for example.             ")
    public Boolean getNative() {
        return this._native;
    }

    public void setNative(Boolean _native) {
        this._native = _native;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignTextOptions signTextOptions = (SignTextOptions)o;
        return Objects.equals(this.left, signTextOptions.left) && Objects.equals(this.top, signTextOptions.top) && Objects.equals(this.width, signTextOptions.width) && Objects.equals(this.height, signTextOptions.height) && Objects.equals((Object)this.locationMeasureType, (Object)signTextOptions.locationMeasureType) && Objects.equals((Object)this.sizeMeasureType, (Object)signTextOptions.sizeMeasureType) && Objects.equals((Object)this.stretch, (Object)signTextOptions.stretch) && Objects.equals(this.rotationAngle, signTextOptions.rotationAngle) && Objects.equals((Object)this.horizontalAlignment, (Object)signTextOptions.horizontalAlignment) && Objects.equals((Object)this.verticalAlignment, (Object)signTextOptions.verticalAlignment) && Objects.equals(this.margin, signTextOptions.margin) && Objects.equals((Object)this.marginMeasureType, (Object)signTextOptions.marginMeasureType) && Objects.equals(this.text, signTextOptions.text) && Objects.equals(this.font, signTextOptions.font) && Objects.equals(this.foreColor, signTextOptions.foreColor) && Objects.equals(this.backgroundColor, signTextOptions.backgroundColor) && Objects.equals(this.backgroundBrush, signTextOptions.backgroundBrush) && Objects.equals(this.border, signTextOptions.border) && Objects.equals((Object)this.textHorizontalAlignment, (Object)signTextOptions.textHorizontalAlignment) && Objects.equals((Object)this.textVerticalAlignment, (Object)signTextOptions.textVerticalAlignment) && Objects.equals(this.zorder, signTextOptions.zorder) && Objects.equals(this._native, signTextOptions._native) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.left, this.top, this.width, this.height, this.locationMeasureType, this.sizeMeasureType, this.stretch, this.rotationAngle, this.horizontalAlignment, this.verticalAlignment, this.margin, this.marginMeasureType, this.text, this.font, this.foreColor, this.backgroundColor, this.backgroundBrush, this.border, this.textHorizontalAlignment, this.textVerticalAlignment, this.zorder, this._native, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignTextOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.left)).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    locationMeasureType: ").append(this.toIndentedString((Object)this.locationMeasureType)).append("\n");
        sb.append("    sizeMeasureType: ").append(this.toIndentedString((Object)this.sizeMeasureType)).append("\n");
        sb.append("    stretch: ").append(this.toIndentedString((Object)this.stretch)).append("\n");
        sb.append("    rotationAngle: ").append(this.toIndentedString(this.rotationAngle)).append("\n");
        sb.append("    horizontalAlignment: ").append(this.toIndentedString((Object)this.horizontalAlignment)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("    margin: ").append(this.toIndentedString(this.margin)).append("\n");
        sb.append("    marginMeasureType: ").append(this.toIndentedString((Object)this.marginMeasureType)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    font: ").append(this.toIndentedString(this.font)).append("\n");
        sb.append("    foreColor: ").append(this.toIndentedString(this.foreColor)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    backgroundBrush: ").append(this.toIndentedString(this.backgroundBrush)).append("\n");
        sb.append("    border: ").append(this.toIndentedString(this.border)).append("\n");
        sb.append("    textHorizontalAlignment: ").append(this.toIndentedString((Object)this.textHorizontalAlignment)).append("\n");
        sb.append("    textVerticalAlignment: ").append(this.toIndentedString((Object)this.textVerticalAlignment)).append("\n");
        sb.append("    zorder: ").append(this.toIndentedString(this.zorder)).append("\n");
        sb.append("    _native: ").append(this.toIndentedString(this._native)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextVerticalAlignmentEnum {
        TOP("Top"),
        CENTER("Center"),
        BOTTOM("Bottom");

        private String value;

        private TextVerticalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextVerticalAlignmentEnum fromValue(String text) {
            for (TextVerticalAlignmentEnum b : TextVerticalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextVerticalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, TextVerticalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextVerticalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextVerticalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextHorizontalAlignmentEnum {
        LEFT("Left"),
        CENTER("Center"),
        RIGHT("Right");

        private String value;

        private TextHorizontalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextHorizontalAlignmentEnum fromValue(String text) {
            for (TextHorizontalAlignmentEnum b : TextHorizontalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextHorizontalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, TextHorizontalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextHorizontalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextHorizontalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MarginMeasureTypeEnum {
        PIXELS("Pixels"),
        PERCENTS("Percents"),
        MILLIMETERS("Millimeters");

        private String value;

        private MarginMeasureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MarginMeasureTypeEnum fromValue(String text) {
            for (MarginMeasureTypeEnum b : MarginMeasureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MarginMeasureTypeEnum> {
            public void write(JsonWriter jsonWriter, MarginMeasureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MarginMeasureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MarginMeasureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerticalAlignmentEnum {
        NONE("None"),
        TOP("Top"),
        CENTER("Center"),
        BOTTOM("Bottom");

        private String value;

        private VerticalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerticalAlignmentEnum fromValue(String text) {
            for (VerticalAlignmentEnum b : VerticalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerticalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, VerticalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerticalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerticalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HorizontalAlignmentEnum {
        NONE("None"),
        LEFT("Left"),
        CENTER("Center"),
        RIGHT("Right");

        private String value;

        private HorizontalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HorizontalAlignmentEnum fromValue(String text) {
            for (HorizontalAlignmentEnum b : HorizontalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HorizontalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, HorizontalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HorizontalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HorizontalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StretchEnum {
        NONE("None"),
        PAGEWIDTH("PageWidth"),
        PAGEHEIGHT("PageHeight"),
        PAGEAREA("PageArea");

        private String value;

        private StretchEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StretchEnum fromValue(String text) {
            for (StretchEnum b : StretchEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StretchEnum> {
            public void write(JsonWriter jsonWriter, StretchEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StretchEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StretchEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SizeMeasureTypeEnum {
        PIXELS("Pixels"),
        PERCENTS("Percents"),
        MILLIMETERS("Millimeters");

        private String value;

        private SizeMeasureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SizeMeasureTypeEnum fromValue(String text) {
            for (SizeMeasureTypeEnum b : SizeMeasureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SizeMeasureTypeEnum> {
            public void write(JsonWriter jsonWriter, SizeMeasureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SizeMeasureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SizeMeasureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LocationMeasureTypeEnum {
        PIXELS("Pixels"),
        PERCENTS("Percents"),
        MILLIMETERS("Millimeters");

        private String value;

        private LocationMeasureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LocationMeasureTypeEnum fromValue(String text) {
            for (LocationMeasureTypeEnum b : LocationMeasureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LocationMeasureTypeEnum> {
            public void write(JsonWriter jsonWriter, LocationMeasureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LocationMeasureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LocationMeasureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

