/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Describes base class for signatures")
public class Signature {
    @SerializedName(value="signatureType")
    private SignatureTypeEnum signatureType = null;
    @SerializedName(value="pageNumber")
    private Integer pageNumber = null;
    @SerializedName(value="signatureId")
    private String signatureId = null;
    @SerializedName(value="isSignature")
    private Boolean isSignature = null;
    @SerializedName(value="createdOn")
    private OffsetDateTime createdOn = null;
    @SerializedName(value="modifiedOn")
    private OffsetDateTime modifiedOn = null;
    @SerializedName(value="top")
    private Integer top = null;
    @SerializedName(value="left")
    private Integer left = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;

    public Signature signatureType(SignatureTypeEnum signatureType) {
        this.signatureType = signatureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the signature type (Text, Image, Digital, Barcode, QRCode, Stamp)")
    public SignatureTypeEnum getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureTypeEnum signatureType) {
        this.signatureType = signatureType;
    }

    public Signature pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(value="Specifies the page signature was found on")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Signature signatureId(String signatureId) {
        this.signatureId = signatureId;
        return this;
    }

    @ApiModelProperty(value="Unique signature identifier to modify signature in the document over Update or Delete methods. This property will be set automatically after Sign or Search method being called. If this property was saved before it can be set manually to manipulate the signature.")
    public String getSignatureId() {
        return this.signatureId;
    }

    public void setSignatureId(String signatureId) {
        this.signatureId = signatureId;
    }

    public Signature isSignature(Boolean isSignature) {
        this.isSignature = isSignature;
        return this;
    }

    @ApiModelProperty(required=true, value="Get or set flag to indicate if this component is Signature or document content. This property is being used with Update method to set element as signature (true) or document element (false).             ")
    public Boolean getIsSignature() {
        return this.isSignature;
    }

    public void setIsSignature(Boolean isSignature) {
        this.isSignature = isSignature;
    }

    public Signature createdOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @ApiModelProperty(required=true, value="Get or set the signature creation date")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
    }

    public Signature modifiedOn(OffsetDateTime modifiedOn) {
        this.modifiedOn = modifiedOn;
        return this;
    }

    @ApiModelProperty(required=true, value="Get or set the signature modification date")
    public OffsetDateTime getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(OffsetDateTime modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public Signature top(Integer top) {
        this.top = top;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies top position of signature")
    public Integer getTop() {
        return this.top;
    }

    public void setTop(Integer top) {
        this.top = top;
    }

    public Signature left(Integer left) {
        this.left = left;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies left position of signature")
    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public Signature width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies width of signature")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Signature height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies height of signature")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return Objects.equals((Object)this.signatureType, (Object)signature.signatureType) && Objects.equals(this.pageNumber, signature.pageNumber) && Objects.equals(this.signatureId, signature.signatureId) && Objects.equals(this.isSignature, signature.isSignature) && Objects.equals(this.createdOn, signature.createdOn) && Objects.equals(this.modifiedOn, signature.modifiedOn) && Objects.equals(this.top, signature.top) && Objects.equals(this.left, signature.left) && Objects.equals(this.width, signature.width) && Objects.equals(this.height, signature.height);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signatureType, this.pageNumber, this.signatureId, this.isSignature, this.createdOn, this.modifiedOn, this.top, this.left, this.width, this.height});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Signature {\n");
        sb.append("    signatureType: ").append(this.toIndentedString((Object)this.signatureType)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    signatureId: ").append(this.toIndentedString(this.signatureId)).append("\n");
        sb.append("    isSignature: ").append(this.toIndentedString(this.isSignature)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    modifiedOn: ").append(this.toIndentedString(this.modifiedOn)).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.left)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SignatureTypeEnum {
        NONE("None"),
        TEXT("Text"),
        IMAGE("Image"),
        DIGITAL("Digital"),
        BARCODE("Barcode"),
        QRCODE("QRCode"),
        STAMP("Stamp"),
        FORMFIELD("FormField"),
        METADATA("Metadata");

        private String value;

        private SignatureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SignatureTypeEnum fromValue(String text) {
            for (SignatureTypeEnum b : SignatureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SignatureTypeEnum> {
            public void write(JsonWriter jsonWriter, SignatureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SignatureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SignatureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

