/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Appearance is a base class for keeping additional information for various options")
public class SignatureAppearance {
    @SerializedName(value="appearanceType")
    private AppearanceTypeEnum appearanceType = null;

    public SignatureAppearance appearanceType(AppearanceTypeEnum appearanceType) {
        this.appearanceType = appearanceType;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the type of appearance")
    public AppearanceTypeEnum getAppearanceType() {
        return this.appearanceType;
    }

    public void setAppearanceType(AppearanceTypeEnum appearanceType) {
        this.appearanceType = appearanceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureAppearance signatureAppearance = (SignatureAppearance)o;
        return Objects.equals((Object)this.appearanceType, (Object)signatureAppearance.appearanceType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appearanceType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignatureAppearance {\n");
        sb.append("    appearanceType: ").append(this.toIndentedString((Object)this.appearanceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AppearanceTypeEnum {
        UNDEFINED("Undefined"),
        PDFTEXTANNOTATION("PdfTextAnnotation"),
        PDFTEXTSTICKER("PdfTextSticker"),
        IMAGE("Image"),
        DIGITALSIGNATURE("DigitalSignature"),
        PDFDIGITALSIGNATURE("PdfDigitalSignature");

        private String value;

        private AppearanceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AppearanceTypeEnum fromValue(String text) {
            for (AppearanceTypeEnum b : AppearanceTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AppearanceTypeEnum> {
            public void write(JsonWriter jsonWriter, AppearanceTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AppearanceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AppearanceTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

