/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.BorderLine;
import com.groupdocs.cloud.signature.model.Color;
import com.groupdocs.cloud.signature.model.SignatureFont;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Specify Stamp line properties")
public class StampLine {
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="backgroundColor")
    private Color backgroundColor = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="font")
    private SignatureFont font = null;
    @SerializedName(value="textColor")
    private Color textColor = null;
    @SerializedName(value="textBottomIntent")
    private Integer textBottomIntent = null;
    @SerializedName(value="textRepeatType")
    private TextRepeatTypeEnum textRepeatType = null;
    @SerializedName(value="outerBorder")
    private BorderLine outerBorder = null;
    @SerializedName(value="innerBorder")
    private BorderLine innerBorder = null;
    @SerializedName(value="visible")
    private Boolean visible = null;

    public StampLine height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the line height on Stamp")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public StampLine backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the background color of signature")
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public StampLine text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the text of stamp line")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public StampLine font(SignatureFont font) {
        this.font = font;
        return this;
    }

    @ApiModelProperty(value="Get or set Font of Stamp Line text")
    public SignatureFont getFont() {
        return this.font;
    }

    public void setFont(SignatureFont font) {
        this.font = font;
    }

    public StampLine textColor(Color textColor) {
        this.textColor = textColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the text color of signature")
    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public StampLine textBottomIntent(Integer textBottomIntent) {
        this.textBottomIntent = textBottomIntent;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the bottom intent of text")
    public Integer getTextBottomIntent() {
        return this.textBottomIntent;
    }

    public void setTextBottomIntent(Integer textBottomIntent) {
        this.textBottomIntent = textBottomIntent;
    }

    public StampLine textRepeatType(TextRepeatTypeEnum textRepeatType) {
        this.textRepeatType = textRepeatType;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets text repeat type")
    public TextRepeatTypeEnum getTextRepeatType() {
        return this.textRepeatType;
    }

    public void setTextRepeatType(TextRepeatTypeEnum textRepeatType) {
        this.textRepeatType = textRepeatType;
    }

    public StampLine outerBorder(BorderLine outerBorder) {
        this.outerBorder = outerBorder;
        return this;
    }

    @ApiModelProperty(value="Setup Outer Border")
    public BorderLine getOuterBorder() {
        return this.outerBorder;
    }

    public void setOuterBorder(BorderLine outerBorder) {
        this.outerBorder = outerBorder;
    }

    public StampLine innerBorder(BorderLine innerBorder) {
        this.innerBorder = innerBorder;
        return this;
    }

    @ApiModelProperty(value="Setup Internal Border")
    public BorderLine getInnerBorder() {
        return this.innerBorder;
    }

    public void setInnerBorder(BorderLine innerBorder) {
        this.innerBorder = innerBorder;
    }

    public StampLine visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @ApiModelProperty(required=true, value="Get and set visibility of Stamp Line")
    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StampLine stampLine = (StampLine)o;
        return Objects.equals(this.height, stampLine.height) && Objects.equals(this.backgroundColor, stampLine.backgroundColor) && Objects.equals(this.text, stampLine.text) && Objects.equals(this.font, stampLine.font) && Objects.equals(this.textColor, stampLine.textColor) && Objects.equals(this.textBottomIntent, stampLine.textBottomIntent) && Objects.equals((Object)this.textRepeatType, (Object)stampLine.textRepeatType) && Objects.equals(this.outerBorder, stampLine.outerBorder) && Objects.equals(this.innerBorder, stampLine.innerBorder) && Objects.equals(this.visible, stampLine.visible);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.height, this.backgroundColor, this.text, this.font, this.textColor, this.textBottomIntent, this.textRepeatType, this.outerBorder, this.innerBorder, this.visible});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StampLine {\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    font: ").append(this.toIndentedString(this.font)).append("\n");
        sb.append("    textColor: ").append(this.toIndentedString(this.textColor)).append("\n");
        sb.append("    textBottomIntent: ").append(this.toIndentedString(this.textBottomIntent)).append("\n");
        sb.append("    textRepeatType: ").append(this.toIndentedString((Object)this.textRepeatType)).append("\n");
        sb.append("    outerBorder: ").append(this.toIndentedString(this.outerBorder)).append("\n");
        sb.append("    innerBorder: ").append(this.toIndentedString(this.innerBorder)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextRepeatTypeEnum {
        NONE("None"),
        FULLTEXTREPEAT("FullTextRepeat"),
        REPEATWITHTRUNCATION("RepeatWithTruncation");

        private String value;

        private TextRepeatTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextRepeatTypeEnum fromValue(String text) {
            for (TextRepeatTypeEnum b : TextRepeatTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextRepeatTypeEnum> {
            public void write(JsonWriter jsonWriter, TextRepeatTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextRepeatTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextRepeatTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

