/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Base container class for update signature options")
public class UpdateOptions {
    @SerializedName(value="signatureType")
    private SignatureTypeEnum signatureType = null;
    @SerializedName(value="signatureId")
    private String signatureId = null;
    @SerializedName(value="left")
    private Integer left = null;
    @SerializedName(value="top")
    private Integer top = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="isSignature")
    private Boolean isSignature = null;
    @SerializedName(value="text")
    private String text = null;

    public UpdateOptions signatureType(SignatureTypeEnum signatureType) {
        this.signatureType = signatureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the type of signature")
    public SignatureTypeEnum getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureTypeEnum signatureType) {
        this.signatureType = signatureType;
    }

    public UpdateOptions signatureId(String signatureId) {
        this.signatureId = signatureId;
        return this;
    }

    @ApiModelProperty(value="Unique signature identifier to modify signature in the document over Update or Delete methods. This property will be set automatically after Sign or Search method being called. If this property was saved before it can be set manually to manipulate the signature.              ")
    public String getSignatureId() {
        return this.signatureId;
    }

    public void setSignatureId(String signatureId) {
        this.signatureId = signatureId;
    }

    public UpdateOptions left(Integer left) {
        this.left = left;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies left position of signature")
    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public UpdateOptions top(Integer top) {
        this.top = top;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies top position of signature")
    public Integer getTop() {
        return this.top;
    }

    public void setTop(Integer top) {
        this.top = top;
    }

    public UpdateOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies width of signature")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public UpdateOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies height of signature")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public UpdateOptions isSignature(Boolean isSignature) {
        this.isSignature = isSignature;
        return this;
    }

    @ApiModelProperty(required=true, value="Get or set flag to indicate if this component is Signature or document content. This property is being used with Update method to set element as signature (true) or document element (false).             ")
    public Boolean getIsSignature() {
        return this.isSignature;
    }

    public void setIsSignature(Boolean isSignature) {
        this.isSignature = isSignature;
    }

    public UpdateOptions text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="The text to update text signature")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOptions updateOptions = (UpdateOptions)o;
        return Objects.equals((Object)this.signatureType, (Object)updateOptions.signatureType) && Objects.equals(this.signatureId, updateOptions.signatureId) && Objects.equals(this.left, updateOptions.left) && Objects.equals(this.top, updateOptions.top) && Objects.equals(this.width, updateOptions.width) && Objects.equals(this.height, updateOptions.height) && Objects.equals(this.isSignature, updateOptions.isSignature) && Objects.equals(this.text, updateOptions.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signatureType, this.signatureId, this.left, this.top, this.width, this.height, this.isSignature, this.text});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateOptions {\n");
        sb.append("    signatureType: ").append(this.toIndentedString((Object)this.signatureType)).append("\n");
        sb.append("    signatureId: ").append(this.toIndentedString(this.signatureId)).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.left)).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    isSignature: ").append(this.toIndentedString(this.isSignature)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SignatureTypeEnum {
        NONE("None"),
        TEXT("Text"),
        IMAGE("Image"),
        DIGITAL("Digital"),
        BARCODE("Barcode"),
        QRCODE("QRCode"),
        STAMP("Stamp"),
        FORMFIELD("FormField"),
        METADATA("Metadata");

        private String value;

        private SignatureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SignatureTypeEnum fromValue(String text) {
            for (SignatureTypeEnum b : SignatureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SignatureTypeEnum> {
            public void write(JsonWriter jsonWriter, SignatureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SignatureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SignatureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

