/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.signature.model.FileInfo;
import com.groupdocs.cloud.signature.model.Signature;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Update result information")
public class UpdateResult {
    @SerializedName(value="fileInfo")
    private FileInfo fileInfo = null;
    @SerializedName(value="size")
    private Long size = null;
    @SerializedName(value="succeeded")
    private List<Signature> succeeded = null;
    @SerializedName(value="failed")
    private List<Signature> failed = null;

    public UpdateResult fileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }

    @ApiModelProperty(value="Updated document file info")
    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public UpdateResult size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="Source document size in bytes")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public UpdateResult succeeded(List<Signature> succeeded) {
        this.succeeded = succeeded;
        return this;
    }

    public UpdateResult addSucceededItem(Signature succeededItem) {
        if (this.succeeded == null) {
            this.succeeded = new ArrayList<Signature>();
        }
        this.succeeded.add(succeededItem);
        return this;
    }

    @ApiModelProperty(value="List of successfully modified signatures")
    public List<Signature> getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(List<Signature> succeeded) {
        this.succeeded = succeeded;
    }

    public UpdateResult failed(List<Signature> failed) {
        this.failed = failed;
        return this;
    }

    public UpdateResult addFailedItem(Signature failedItem) {
        if (this.failed == null) {
            this.failed = new ArrayList<Signature>();
        }
        this.failed.add(failedItem);
        return this;
    }

    @ApiModelProperty(value="List of signatures that were not updated")
    public List<Signature> getFailed() {
        return this.failed;
    }

    public void setFailed(List<Signature> failed) {
        this.failed = failed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateResult updateResult = (UpdateResult)o;
        return Objects.equals(this.fileInfo, updateResult.fileInfo) && Objects.equals(this.size, updateResult.size) && Objects.equals(this.succeeded, updateResult.succeeded) && Objects.equals(this.failed, updateResult.failed);
    }

    public int hashCode() {
        return Objects.hash(this.fileInfo, this.size, this.succeeded, this.failed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateResult {\n");
        sb.append("    fileInfo: ").append(this.toIndentedString(this.fileInfo)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    succeeded: ").append(this.toIndentedString(this.succeeded)).append("\n");
        sb.append("    failed: ").append(this.toIndentedString(this.failed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

