/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.signature.model.VerifyOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Defines options to verify Digital signature within a document")
public class VerifyDigitalOptions
extends VerifyOptions {
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="certificateFilePath")
    private String certificateFilePath = null;
    @SerializedName(value="comments")
    private String comments = null;
    @SerializedName(value="signDateTimeFrom")
    private OffsetDateTime signDateTimeFrom = null;
    @SerializedName(value="signDateTimeTo")
    private OffsetDateTime signDateTimeTo = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="contact")
    private String contact = null;
    @SerializedName(value="location")
    private String location = null;

    public VerifyDigitalOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Password of Digital Certificate if required")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public VerifyDigitalOptions certificateFilePath(String certificateFilePath) {
        this.certificateFilePath = certificateFilePath;
        return this;
    }

    @ApiModelProperty(value="File Guid of Digital Certificate")
    public String getCertificateFilePath() {
        return this.certificateFilePath;
    }

    public void setCertificateFilePath(String certificateFilePath) {
        this.certificateFilePath = certificateFilePath;
    }

    public VerifyDigitalOptions comments(String comments) {
        this.comments = comments;
        return this;
    }

    @ApiModelProperty(value="Comments of Digital Signature to validate Suitable for Spreadsheet and Words Processing document types")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public VerifyDigitalOptions signDateTimeFrom(OffsetDateTime signDateTimeFrom) {
        this.signDateTimeFrom = signDateTimeFrom;
        return this;
    }

    @ApiModelProperty(value="Date and time range of Digital Signature to validate. Null value will be ignored. Suitable for Spreadsheet and Words Processing document types")
    public OffsetDateTime getSignDateTimeFrom() {
        return this.signDateTimeFrom;
    }

    public void setSignDateTimeFrom(OffsetDateTime signDateTimeFrom) {
        this.signDateTimeFrom = signDateTimeFrom;
    }

    public VerifyDigitalOptions signDateTimeTo(OffsetDateTime signDateTimeTo) {
        this.signDateTimeTo = signDateTimeTo;
        return this;
    }

    @ApiModelProperty(value="Date and time range of Digital Signature to validate. Null value will be ignored Suitable for Spreadsheet and Words Processing document types")
    public OffsetDateTime getSignDateTimeTo() {
        return this.signDateTimeTo;
    }

    public void setSignDateTimeTo(OffsetDateTime signDateTimeTo) {
        this.signDateTimeTo = signDateTimeTo;
    }

    public VerifyDigitalOptions reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="Reason of Digital Signature to validate Suitable for Pdf document type")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public VerifyDigitalOptions contact(String contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="Signature Contact to validate Suitable for Pdf document type")
    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public VerifyDigitalOptions location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(value="Signature Location to validate Suitable for Pdf document type")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyDigitalOptions verifyDigitalOptions = (VerifyDigitalOptions)o;
        return Objects.equals(this.password, verifyDigitalOptions.password) && Objects.equals(this.certificateFilePath, verifyDigitalOptions.certificateFilePath) && Objects.equals(this.comments, verifyDigitalOptions.comments) && Objects.equals(this.signDateTimeFrom, verifyDigitalOptions.signDateTimeFrom) && Objects.equals(this.signDateTimeTo, verifyDigitalOptions.signDateTimeTo) && Objects.equals(this.reason, verifyDigitalOptions.reason) && Objects.equals(this.contact, verifyDigitalOptions.contact) && Objects.equals(this.location, verifyDigitalOptions.location) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.password, this.certificateFilePath, this.comments, this.signDateTimeFrom, this.signDateTimeTo, this.reason, this.contact, this.location, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerifyDigitalOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    certificateFilePath: ").append(this.toIndentedString(this.certificateFilePath)).append("\n");
        sb.append("    comments: ").append(this.toIndentedString(this.comments)).append("\n");
        sb.append("    signDateTimeFrom: ").append(this.toIndentedString(this.signDateTimeFrom)).append("\n");
        sb.append("    signDateTimeTo: ").append(this.toIndentedString(this.signDateTimeTo)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

