/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.model.CloudFileRequest;
import com.groupdocs.model.CloudFileResponse;
import com.groupdocs.model.CloudFileResponseWithAdditionalInfo;
import com.groupdocs.model.CloudHugoResponse;
import com.groupdocs.model.CloudTextResponse;
import com.groupdocs.model.CsvFileRequest;
import com.groupdocs.model.FileRequest;
import com.groupdocs.model.HealthCheckEntity;
import com.groupdocs.model.HealthCheckStatus;
import com.groupdocs.model.HtmlFileRequest;
import com.groupdocs.model.HugoRequest;
import com.groupdocs.model.ImageToFileRequest;
import com.groupdocs.model.ImageToTextRequest;
import com.groupdocs.model.LanguagePairData;
import com.groupdocs.model.MarkdownFileRequest;
import com.groupdocs.model.MediaToFileRequest;
import com.groupdocs.model.MediaToTextRequest;
import com.groupdocs.model.PdfFileRequest;
import com.groupdocs.model.PresentationFileRequest;
import com.groupdocs.model.SpreadsheetFileRequest;
import com.groupdocs.model.SrtFileRequest;
import com.groupdocs.model.StatusResponse;
import com.groupdocs.model.StringStringTuple;
import com.groupdocs.model.TextDocumentFileRequest;
import com.groupdocs.model.TextRequest;
import com.groupdocs.model.UrlFileInfo;
import com.groupdocs.model.WorksheetData;
import com.groupdocs.model.XmlFileRequest;
import io.gsonfire.GsonFireBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Map;
import okio.ByteString;

public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson;
    private static DateTypeAdapter dateTypeAdapter;
    private static SqlDateTypeAdapter sqlDateTypeAdapter;
    private static ByteArrayAdapter byteArrayAdapter;

    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder();
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class)classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            }
            return gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            throw e;
        }
    }

    public static <T> T deserialize(InputStream inputStream2, Type returnType) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream2, StandardCharsets.UTF_8);){
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(reader);
                jsonReader.setLenient(true);
                Object t = gson.fromJson(jsonReader, returnType);
                return t;
            }
            Object t = gson.fromJson((Reader)reader, returnType);
            return t;
        }
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }

    static {
        isLenientOnJson = false;
        dateTypeAdapter = new DateTypeAdapter();
        sqlDateTypeAdapter = new SqlDateTypeAdapter();
        byteArrayAdapter = new ByteArrayAdapter();
        GsonBuilder gsonBuilder = JSON.createGson();
        gsonBuilder.registerTypeAdapter((Type)((Object)java.util.Date.class), dateTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)Date.class), sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)byte[].class), byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new CloudFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CloudFileResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CloudFileResponseWithAdditionalInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CloudHugoResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CloudTextResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CsvFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new HealthCheckEntity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new HealthCheckStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new HtmlFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new HugoRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ImageToFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ImageToTextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new LanguagePairData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MarkdownFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MediaToFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MediaToTextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PdfFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PresentationFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SpreadsheetFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SrtFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new StatusResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new StringStringTuple.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TextDocumentFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UrlFileInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new WorksheetData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new XmlFileRequest.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    public static class DateTypeAdapter
    extends TypeAdapter<java.util.Date> {
        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.util.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format(date, true);
                out.value(value);
            }
        }

        @Override
        public java.util.Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return ISO8601Utils.parse(date, new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonParseException(e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new Date(this.dateFormat.parse(date).getTime());
                }
                return new Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String bytesAsBase64 = in.nextString();
            ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
            return byteString.toByteArray();
        }
    }
}

