/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.JSON;
import com.groupdocs.model.HttpStatusCode;
import com.groupdocs.model.UrlFileInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class CloudFileResponse {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nullable
    private HttpStatusCode status;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    @Nullable
    private String message;
    public static final String SERIALIZED_NAME_URLS = "urls";
    @SerializedName(value="urls")
    @Nullable
    private Map<String, UrlFileInfo> urls;
    public static final String SERIALIZED_NAME_SCORES = "scores";
    @SerializedName(value="scores")
    @Nullable
    private Map<String, Float> scores;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("status", "message", "urls", "scores"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public CloudFileResponse status(@Nullable HttpStatusCode status) {
        this.status = status;
        return this;
    }

    @Nullable
    public HttpStatusCode getStatus() {
        return this.status;
    }

    public void setStatus(@Nullable HttpStatusCode status) {
        this.status = status;
    }

    public CloudFileResponse message(@Nullable String message) {
        this.message = message;
        return this;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    public CloudFileResponse urls(@Nullable Map<String, UrlFileInfo> urls2) {
        this.urls = urls2;
        return this;
    }

    public CloudFileResponse putUrlsItem(String key, UrlFileInfo urlsItem) {
        if (this.urls == null) {
            this.urls = new HashMap<String, UrlFileInfo>();
        }
        this.urls.put(key, urlsItem);
        return this;
    }

    @Nullable
    public Map<String, UrlFileInfo> getUrls() {
        return this.urls;
    }

    public void setUrls(@Nullable Map<String, UrlFileInfo> urls2) {
        this.urls = urls2;
    }

    public CloudFileResponse scores(@Nullable Map<String, Float> scores) {
        this.scores = scores;
        return this;
    }

    public CloudFileResponse putScoresItem(String key, Float scoresItem) {
        if (this.scores == null) {
            this.scores = new HashMap<String, Float>();
        }
        this.scores.put(key, scoresItem);
        return this;
    }

    @Nullable
    public Map<String, Float> getScores() {
        return this.scores;
    }

    public void setScores(@Nullable Map<String, Float> scores) {
        this.scores = scores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudFileResponse cloudFileResponse = (CloudFileResponse)o;
        return Objects.equals((Object)this.status, (Object)cloudFileResponse.status) && Objects.equals(this.message, cloudFileResponse.message) && Objects.equals(this.urls, cloudFileResponse.urls) && Objects.equals(this.scores, cloudFileResponse.scores);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.message, this.urls, this.scores});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudFileResponse {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    urls: ").append(this.toIndentedString(this.urls)).append("\n");
        sb.append("    scores: ").append(this.toIndentedString(this.scores)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CloudFileResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CloudFileResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            HttpStatusCode.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE).toString()));
        }
    }

    public static CloudFileResponse fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, CloudFileResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CloudFileResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<CloudFileResponse> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(CloudFileResponse.class));
            return new TypeAdapter<CloudFileResponse>(){

                @Override
                public void write(JsonWriter out, CloudFileResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public CloudFileResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CloudFileResponse.validateJsonElement(jsonElement);
                    return (CloudFileResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

