/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.JSON;
import com.groupdocs.model.HttpStatusCode;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class CloudTextResponse {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nullable
    private HttpStatusCode status;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    @Nullable
    private String message;
    public static final String SERIALIZED_NAME_TRANSLATIONS = "translations";
    @SerializedName(value="translations")
    @Nullable
    private Map<String, List<String>> translations;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("status", "message", "translations"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public CloudTextResponse status(@Nullable HttpStatusCode status) {
        this.status = status;
        return this;
    }

    @Nullable
    public HttpStatusCode getStatus() {
        return this.status;
    }

    public void setStatus(@Nullable HttpStatusCode status) {
        this.status = status;
    }

    public CloudTextResponse message(@Nullable String message) {
        this.message = message;
        return this;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    public CloudTextResponse translations(@Nullable Map<String, List<String>> translations) {
        this.translations = translations;
        return this;
    }

    public CloudTextResponse putTranslationsItem(String key, List<String> translationsItem) {
        if (this.translations == null) {
            this.translations = new HashMap<String, List<String>>();
        }
        this.translations.put(key, translationsItem);
        return this;
    }

    @Nullable
    public Map<String, List<String>> getTranslations() {
        return this.translations;
    }

    public void setTranslations(@Nullable Map<String, List<String>> translations) {
        this.translations = translations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudTextResponse cloudTextResponse = (CloudTextResponse)o;
        return Objects.equals((Object)this.status, (Object)cloudTextResponse.status) && Objects.equals(this.message, cloudTextResponse.message) && Objects.equals(this.translations, cloudTextResponse.translations);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.message, this.translations});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudTextResponse {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    translations: ").append(this.toIndentedString(this.translations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CloudTextResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CloudTextResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            HttpStatusCode.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE).toString()));
        }
    }

    public static CloudTextResponse fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, CloudTextResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CloudTextResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<CloudTextResponse> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(CloudTextResponse.class));
            return new TypeAdapter<CloudTextResponse>(){

                @Override
                public void write(JsonWriter out, CloudTextResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public CloudTextResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CloudTextResponse.validateJsonElement(jsonElement);
                    return (CloudTextResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

