/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class CsvFileRequest {
    public static final String SERIALIZED_NAME_SOURCE_LANGUAGE = "sourceLanguage";
    @SerializedName(value="sourceLanguage")
    @Nonnull
    private String sourceLanguage = "en";
    public static final String SERIALIZED_NAME_TARGET_LANGUAGES = "targetLanguages";
    @SerializedName(value="targetLanguages")
    @Nonnull
    private List<String> targetLanguages = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ORIGINAL_FILE_NAME = "originalFileName";
    @SerializedName(value="originalFileName")
    @Nullable
    private String originalFileName;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    @Nonnull
    private String url;
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    @Nullable
    private String origin;
    public static final String SERIALIZED_NAME_IS_NEED_ALIGNMENT = "isNeedAlignment";
    @SerializedName(value="isNeedAlignment")
    @Nullable
    private Boolean isNeedAlignment;
    public static final String SERIALIZED_NAME_TRANSLATION_DICTIONARY = "translationDictionary";
    @SerializedName(value="translationDictionary")
    @Nullable
    private Map<String, String> translationDictionary;
    public static final String SERIALIZED_NAME_SAVING_MODE = "savingMode";
    @SerializedName(value="savingMode")
    @Nullable
    private SavingModeEnum savingMode;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    @Nullable
    private FormatEnum format = FormatEnum.CSV;
    public static final String SERIALIZED_NAME_OUTPUT_FORMAT = "outputFormat";
    @SerializedName(value="outputFormat")
    @Nonnull
    private String outputFormat;
    public static final String SERIALIZED_NAME_SEPARATOR = "separator";
    @SerializedName(value="separator")
    @Nullable
    private String separator;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("sourceLanguage", "targetLanguages", "originalFileName", "url", "origin", "isNeedAlignment", "translationDictionary", "savingMode", "format", "outputFormat", "separator"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("sourceLanguage", "targetLanguages", "url", "outputFormat"));

    public CsvFileRequest sourceLanguage(@Nonnull String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
    }

    @Nonnull
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(@Nonnull String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public CsvFileRequest targetLanguages(@Nonnull List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
        return this;
    }

    public CsvFileRequest addTargetLanguagesItem(String targetLanguagesItem) {
        if (this.targetLanguages == null) {
            this.targetLanguages = new ArrayList<String>();
        }
        this.targetLanguages.add(targetLanguagesItem);
        return this;
    }

    @Nonnull
    public List<String> getTargetLanguages() {
        return this.targetLanguages;
    }

    public void setTargetLanguages(@Nonnull List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
    }

    public CsvFileRequest originalFileName(@Nullable String originalFileName) {
        this.originalFileName = originalFileName;
        return this;
    }

    @Nullable
    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public void setOriginalFileName(@Nullable String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public CsvFileRequest url(@Nonnull String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nonnull String url) {
        this.url = url;
    }

    public CsvFileRequest origin(@Nullable String origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    public CsvFileRequest isNeedAlignment(@Nullable Boolean isNeedAlignment) {
        this.isNeedAlignment = isNeedAlignment;
        return this;
    }

    @Nullable
    public Boolean getIsNeedAlignment() {
        return this.isNeedAlignment;
    }

    public void setIsNeedAlignment(@Nullable Boolean isNeedAlignment) {
        this.isNeedAlignment = isNeedAlignment;
    }

    public CsvFileRequest translationDictionary(@Nullable Map<String, String> translationDictionary) {
        this.translationDictionary = translationDictionary;
        return this;
    }

    public CsvFileRequest putTranslationDictionaryItem(String key, String translationDictionaryItem) {
        if (this.translationDictionary == null) {
            this.translationDictionary = new HashMap<String, String>();
        }
        this.translationDictionary.put(key, translationDictionaryItem);
        return this;
    }

    @Nullable
    public Map<String, String> getTranslationDictionary() {
        return this.translationDictionary;
    }

    public void setTranslationDictionary(@Nullable Map<String, String> translationDictionary) {
        this.translationDictionary = translationDictionary;
    }

    public CsvFileRequest savingMode(@Nullable SavingModeEnum savingMode) {
        this.savingMode = savingMode;
        return this;
    }

    @Nullable
    public SavingModeEnum getSavingMode() {
        return this.savingMode;
    }

    public void setSavingMode(@Nullable SavingModeEnum savingMode) {
        this.savingMode = savingMode;
    }

    public CsvFileRequest format(@Nullable FormatEnum format) {
        this.format = format;
        return this;
    }

    @Nullable
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(@Nullable FormatEnum format) {
        this.format = format;
    }

    public CsvFileRequest outputFormat(@Nonnull String outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    @Nonnull
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(@Nonnull String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public CsvFileRequest separator(@Nullable String separator) {
        this.separator = separator;
        return this;
    }

    @Nullable
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(@Nullable String separator) {
        this.separator = separator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvFileRequest csvFileRequest = (CsvFileRequest)o;
        return Objects.equals(this.sourceLanguage, csvFileRequest.sourceLanguage) && Objects.equals(this.targetLanguages, csvFileRequest.targetLanguages) && Objects.equals(this.originalFileName, csvFileRequest.originalFileName) && Objects.equals(this.url, csvFileRequest.url) && Objects.equals(this.origin, csvFileRequest.origin) && Objects.equals(this.isNeedAlignment, csvFileRequest.isNeedAlignment) && Objects.equals(this.translationDictionary, csvFileRequest.translationDictionary) && Objects.equals((Object)this.savingMode, (Object)csvFileRequest.savingMode) && Objects.equals((Object)this.format, (Object)csvFileRequest.format) && Objects.equals(this.outputFormat, csvFileRequest.outputFormat) && Objects.equals(this.separator, csvFileRequest.separator);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceLanguage, this.targetLanguages, this.originalFileName, this.url, this.origin, this.isNeedAlignment, this.translationDictionary, this.savingMode, this.format, this.outputFormat, this.separator});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CsvFileRequest {\n");
        sb.append("    sourceLanguage: ").append(this.toIndentedString(this.sourceLanguage)).append("\n");
        sb.append("    targetLanguages: ").append(this.toIndentedString(this.targetLanguages)).append("\n");
        sb.append("    originalFileName: ").append(this.toIndentedString(this.originalFileName)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    isNeedAlignment: ").append(this.toIndentedString(this.isNeedAlignment)).append("\n");
        sb.append("    translationDictionary: ").append(this.toIndentedString(this.translationDictionary)).append("\n");
        sb.append("    savingMode: ").append(this.toIndentedString((Object)this.savingMode)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    outputFormat: ").append(this.toIndentedString(this.outputFormat)).append("\n");
        sb.append("    separator: ").append(this.toIndentedString(this.separator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CsvFileRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CsvFileRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceLanguage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `targetLanguages` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `originalFileName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGIN) != null && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `origin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAVING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `savingMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SAVING_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAVING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonNull()) {
            SavingModeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SAVING_MODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORMAT) != null && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `format` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORMAT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORMAT) != null && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonNull()) {
            FormatEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_FORMAT));
        }
        if (!jsonObj.get(SERIALIZED_NAME_OUTPUT_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `outputFormat` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUTPUT_FORMAT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SEPARATOR) != null && !jsonObj.get(SERIALIZED_NAME_SEPARATOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SEPARATOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `separator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SEPARATOR).toString()));
        }
    }

    public static CsvFileRequest fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, CsvFileRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FormatEnum {
        UNKNOWN("Unknown"),
        CSV("Csv"),
        TSV("Tsv");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            FormatEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<FormatEnum> {
            @Override
            public void write(JsonWriter jsonWriter, FormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public FormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FormatEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SavingModeEnum {
        FILES("Files"),
        ARCHIVE("Archive"),
        BOTH("Both");

        private String value;

        private SavingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SavingModeEnum fromValue(String value) {
            for (SavingModeEnum b : SavingModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            SavingModeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<SavingModeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, SavingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public SavingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SavingModeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CsvFileRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<CsvFileRequest> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(CsvFileRequest.class));
            return new TypeAdapter<CsvFileRequest>(){

                @Override
                public void write(JsonWriter out, CsvFileRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public CsvFileRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CsvFileRequest.validateJsonElement(jsonElement);
                    return (CsvFileRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

