/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.JSON;
import com.groupdocs.model.WorksheetData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class SpreadsheetFileRequest {
    public static final String SERIALIZED_NAME_SOURCE_LANGUAGE = "sourceLanguage";
    @SerializedName(value="sourceLanguage")
    @Nonnull
    private String sourceLanguage = "en";
    public static final String SERIALIZED_NAME_TARGET_LANGUAGES = "targetLanguages";
    @SerializedName(value="targetLanguages")
    @Nonnull
    private List<String> targetLanguages = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ORIGINAL_FILE_NAME = "originalFileName";
    @SerializedName(value="originalFileName")
    @Nullable
    private String originalFileName;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    @Nonnull
    private String url;
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    @Nullable
    private String origin;
    public static final String SERIALIZED_NAME_IS_NEED_ALIGNMENT = "isNeedAlignment";
    @SerializedName(value="isNeedAlignment")
    @Nullable
    private Boolean isNeedAlignment;
    public static final String SERIALIZED_NAME_TRANSLATION_DICTIONARY = "translationDictionary";
    @SerializedName(value="translationDictionary")
    @Nullable
    private Map<String, String> translationDictionary;
    public static final String SERIALIZED_NAME_SAVING_MODE = "savingMode";
    @SerializedName(value="savingMode")
    @Nullable
    private SavingModeEnum savingMode;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    @Nonnull
    private FormatEnum format = FormatEnum.XLSX;
    public static final String SERIALIZED_NAME_OUTPUT_FORMAT = "outputFormat";
    @SerializedName(value="outputFormat")
    @Nonnull
    private OutputFormatEnum outputFormat;
    public static final String SERIALIZED_NAME_WORKSHEETS = "worksheets";
    @SerializedName(value="worksheets")
    @Nullable
    private List<Integer> worksheets;
    public static final String SERIALIZED_NAME_RANGES = "ranges";
    @SerializedName(value="ranges")
    @Nullable
    private Map<String, WorksheetData> ranges;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("sourceLanguage", "targetLanguages", "originalFileName", "url", "origin", "isNeedAlignment", "translationDictionary", "savingMode", "format", "outputFormat", "worksheets", "ranges"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("sourceLanguage", "targetLanguages", "url", "format", "outputFormat"));

    public SpreadsheetFileRequest sourceLanguage(@Nonnull String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
    }

    @Nonnull
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(@Nonnull String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public SpreadsheetFileRequest targetLanguages(@Nonnull List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
        return this;
    }

    public SpreadsheetFileRequest addTargetLanguagesItem(String targetLanguagesItem) {
        if (this.targetLanguages == null) {
            this.targetLanguages = new ArrayList<String>();
        }
        this.targetLanguages.add(targetLanguagesItem);
        return this;
    }

    @Nonnull
    public List<String> getTargetLanguages() {
        return this.targetLanguages;
    }

    public void setTargetLanguages(@Nonnull List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
    }

    public SpreadsheetFileRequest originalFileName(@Nullable String originalFileName) {
        this.originalFileName = originalFileName;
        return this;
    }

    @Nullable
    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public void setOriginalFileName(@Nullable String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public SpreadsheetFileRequest url(@Nonnull String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nonnull String url) {
        this.url = url;
    }

    public SpreadsheetFileRequest origin(@Nullable String origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    public SpreadsheetFileRequest isNeedAlignment(@Nullable Boolean isNeedAlignment) {
        this.isNeedAlignment = isNeedAlignment;
        return this;
    }

    @Nullable
    public Boolean getIsNeedAlignment() {
        return this.isNeedAlignment;
    }

    public void setIsNeedAlignment(@Nullable Boolean isNeedAlignment) {
        this.isNeedAlignment = isNeedAlignment;
    }

    public SpreadsheetFileRequest translationDictionary(@Nullable Map<String, String> translationDictionary) {
        this.translationDictionary = translationDictionary;
        return this;
    }

    public SpreadsheetFileRequest putTranslationDictionaryItem(String key, String translationDictionaryItem) {
        if (this.translationDictionary == null) {
            this.translationDictionary = new HashMap<String, String>();
        }
        this.translationDictionary.put(key, translationDictionaryItem);
        return this;
    }

    @Nullable
    public Map<String, String> getTranslationDictionary() {
        return this.translationDictionary;
    }

    public void setTranslationDictionary(@Nullable Map<String, String> translationDictionary) {
        this.translationDictionary = translationDictionary;
    }

    public SpreadsheetFileRequest savingMode(@Nullable SavingModeEnum savingMode) {
        this.savingMode = savingMode;
        return this;
    }

    @Nullable
    public SavingModeEnum getSavingMode() {
        return this.savingMode;
    }

    public void setSavingMode(@Nullable SavingModeEnum savingMode) {
        this.savingMode = savingMode;
    }

    public SpreadsheetFileRequest format(@Nonnull FormatEnum format) {
        this.format = format;
        return this;
    }

    @Nonnull
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(@Nonnull FormatEnum format) {
        this.format = format;
    }

    public SpreadsheetFileRequest outputFormat(@Nonnull OutputFormatEnum outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    @Nonnull
    public OutputFormatEnum getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(@Nonnull OutputFormatEnum outputFormat) {
        this.outputFormat = outputFormat;
    }

    public SpreadsheetFileRequest worksheets(@Nullable List<Integer> worksheets) {
        this.worksheets = worksheets;
        return this;
    }

    public SpreadsheetFileRequest addWorksheetsItem(Integer worksheetsItem) {
        if (this.worksheets == null) {
            this.worksheets = new ArrayList<Integer>();
        }
        this.worksheets.add(worksheetsItem);
        return this;
    }

    @Nullable
    public List<Integer> getWorksheets() {
        return this.worksheets;
    }

    public void setWorksheets(@Nullable List<Integer> worksheets) {
        this.worksheets = worksheets;
    }

    public SpreadsheetFileRequest ranges(@Nullable Map<String, WorksheetData> ranges) {
        this.ranges = ranges;
        return this;
    }

    public SpreadsheetFileRequest putRangesItem(String key, WorksheetData rangesItem) {
        if (this.ranges == null) {
            this.ranges = new HashMap<String, WorksheetData>();
        }
        this.ranges.put(key, rangesItem);
        return this;
    }

    @Nullable
    public Map<String, WorksheetData> getRanges() {
        return this.ranges;
    }

    public void setRanges(@Nullable Map<String, WorksheetData> ranges) {
        this.ranges = ranges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpreadsheetFileRequest spreadsheetFileRequest = (SpreadsheetFileRequest)o;
        return Objects.equals(this.sourceLanguage, spreadsheetFileRequest.sourceLanguage) && Objects.equals(this.targetLanguages, spreadsheetFileRequest.targetLanguages) && Objects.equals(this.originalFileName, spreadsheetFileRequest.originalFileName) && Objects.equals(this.url, spreadsheetFileRequest.url) && Objects.equals(this.origin, spreadsheetFileRequest.origin) && Objects.equals(this.isNeedAlignment, spreadsheetFileRequest.isNeedAlignment) && Objects.equals(this.translationDictionary, spreadsheetFileRequest.translationDictionary) && Objects.equals((Object)this.savingMode, (Object)spreadsheetFileRequest.savingMode) && Objects.equals((Object)this.format, (Object)spreadsheetFileRequest.format) && Objects.equals((Object)this.outputFormat, (Object)spreadsheetFileRequest.outputFormat) && Objects.equals(this.worksheets, spreadsheetFileRequest.worksheets) && Objects.equals(this.ranges, spreadsheetFileRequest.ranges);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceLanguage, this.targetLanguages, this.originalFileName, this.url, this.origin, this.isNeedAlignment, this.translationDictionary, this.savingMode, this.format, this.outputFormat, this.worksheets, this.ranges});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpreadsheetFileRequest {\n");
        sb.append("    sourceLanguage: ").append(this.toIndentedString(this.sourceLanguage)).append("\n");
        sb.append("    targetLanguages: ").append(this.toIndentedString(this.targetLanguages)).append("\n");
        sb.append("    originalFileName: ").append(this.toIndentedString(this.originalFileName)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    isNeedAlignment: ").append(this.toIndentedString(this.isNeedAlignment)).append("\n");
        sb.append("    translationDictionary: ").append(this.toIndentedString(this.translationDictionary)).append("\n");
        sb.append("    savingMode: ").append(this.toIndentedString((Object)this.savingMode)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    outputFormat: ").append(this.toIndentedString((Object)this.outputFormat)).append("\n");
        sb.append("    worksheets: ").append(this.toIndentedString(this.worksheets)).append("\n");
        sb.append("    ranges: ").append(this.toIndentedString(this.ranges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SpreadsheetFileRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SpreadsheetFileRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceLanguage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `targetLanguages` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `originalFileName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGIN) != null && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `origin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAVING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `savingMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SAVING_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAVING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonNull()) {
            SavingModeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SAVING_MODE));
        }
        if (!jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `format` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORMAT).toString()));
        }
        FormatEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_FORMAT));
        if (!jsonObj.get(SERIALIZED_NAME_OUTPUT_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `outputFormat` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUTPUT_FORMAT).toString()));
        }
        OutputFormatEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OUTPUT_FORMAT));
        if (jsonObj.get(SERIALIZED_NAME_WORKSHEETS) != null && !jsonObj.get(SERIALIZED_NAME_WORKSHEETS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_WORKSHEETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `worksheets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WORKSHEETS).toString()));
        }
    }

    public static SpreadsheetFileRequest fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, SpreadsheetFileRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FormatEnum {
        UNKNOWN("Unknown"),
        XLS("Xls"),
        XLSX("Xlsx"),
        XLSM("Xlsm"),
        ODS("Ods");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            FormatEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<FormatEnum> {
            @Override
            public void write(JsonWriter jsonWriter, FormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public FormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FormatEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SavingModeEnum {
        FILES("Files"),
        ARCHIVE("Archive"),
        BOTH("Both");

        private String value;

        private SavingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SavingModeEnum fromValue(String value) {
            for (SavingModeEnum b : SavingModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            SavingModeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<SavingModeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, SavingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public SavingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SavingModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OutputFormatEnum {
        XLS("Xls"),
        XLSX("Xlsx"),
        XLSM("Xlsm"),
        XLSB("Xlsb"),
        HTML("Html"),
        PDF("Pdf"),
        XPS("Xps"),
        ODS("Ods"),
        MD("Md"),
        DOCX("Docx"),
        PPTX("Pptx"),
        TIFF("Tiff");

        private String value;

        private OutputFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OutputFormatEnum fromValue(String value) {
            for (OutputFormatEnum b : OutputFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            OutputFormatEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<OutputFormatEnum> {
            @Override
            public void write(JsonWriter jsonWriter, OutputFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public OutputFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OutputFormatEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SpreadsheetFileRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<SpreadsheetFileRequest> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(SpreadsheetFileRequest.class));
            return new TypeAdapter<SpreadsheetFileRequest>(){

                @Override
                public void write(JsonWriter out, SpreadsheetFileRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public SpreadsheetFileRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SpreadsheetFileRequest.validateJsonElement(jsonElement);
                    return (SpreadsheetFileRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

