/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class TextDocumentFileRequest {
    public static final String SERIALIZED_NAME_SOURCE_LANGUAGE = "sourceLanguage";
    @SerializedName(value="sourceLanguage")
    @Nonnull
    private String sourceLanguage = "en";
    public static final String SERIALIZED_NAME_TARGET_LANGUAGES = "targetLanguages";
    @SerializedName(value="targetLanguages")
    @Nonnull
    private List<String> targetLanguages = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ORIGINAL_FILE_NAME = "originalFileName";
    @SerializedName(value="originalFileName")
    @Nullable
    private String originalFileName;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    @Nonnull
    private String url;
    public static final String SERIALIZED_NAME_IS_NEED_ALIGNMENT = "isNeedAlignment";
    @SerializedName(value="isNeedAlignment")
    @Nullable
    private Boolean isNeedAlignment;
    public static final String SERIALIZED_NAME_TRANSLATION_DICTIONARY = "translationDictionary";
    @SerializedName(value="translationDictionary")
    @Nullable
    private Map<String, String> translationDictionary;
    public static final String SERIALIZED_NAME_SAVING_MODE = "savingMode";
    @SerializedName(value="savingMode")
    @Nullable
    private SavingModeEnum savingMode;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    @Nonnull
    private FormatEnum format = FormatEnum.DOCX;
    public static final String SERIALIZED_NAME_OUTPUT_FORMAT = "outputFormat";
    @SerializedName(value="outputFormat")
    @Nonnull
    private String outputFormat;
    public static final String SERIALIZED_NAME_PRESERVE_FORMATTING = "preserveFormatting";
    @SerializedName(value="preserveFormatting")
    @Nullable
    private Boolean preserveFormatting = true;
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    @Nullable
    private String origin;
    public static final String SERIALIZED_NAME_PAGES = "pages";
    @SerializedName(value="pages")
    @Nullable
    private List<Integer> pages;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("sourceLanguage", "targetLanguages", "originalFileName", "url", "isNeedAlignment", "translationDictionary", "savingMode", "format", "outputFormat", "preserveFormatting", "origin", "pages"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("sourceLanguage", "targetLanguages", "url", "format", "outputFormat"));

    public TextDocumentFileRequest sourceLanguage(@Nonnull String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
    }

    @Nonnull
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(@Nonnull String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public TextDocumentFileRequest targetLanguages(@Nonnull List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
        return this;
    }

    public TextDocumentFileRequest addTargetLanguagesItem(String targetLanguagesItem) {
        if (this.targetLanguages == null) {
            this.targetLanguages = new ArrayList<String>();
        }
        this.targetLanguages.add(targetLanguagesItem);
        return this;
    }

    @Nonnull
    public List<String> getTargetLanguages() {
        return this.targetLanguages;
    }

    public void setTargetLanguages(@Nonnull List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
    }

    public TextDocumentFileRequest originalFileName(@Nullable String originalFileName) {
        this.originalFileName = originalFileName;
        return this;
    }

    @Nullable
    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public void setOriginalFileName(@Nullable String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public TextDocumentFileRequest url(@Nonnull String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nonnull String url) {
        this.url = url;
    }

    public TextDocumentFileRequest isNeedAlignment(@Nullable Boolean isNeedAlignment) {
        this.isNeedAlignment = isNeedAlignment;
        return this;
    }

    @Nullable
    public Boolean getIsNeedAlignment() {
        return this.isNeedAlignment;
    }

    public void setIsNeedAlignment(@Nullable Boolean isNeedAlignment) {
        this.isNeedAlignment = isNeedAlignment;
    }

    public TextDocumentFileRequest translationDictionary(@Nullable Map<String, String> translationDictionary) {
        this.translationDictionary = translationDictionary;
        return this;
    }

    public TextDocumentFileRequest putTranslationDictionaryItem(String key, String translationDictionaryItem) {
        if (this.translationDictionary == null) {
            this.translationDictionary = new HashMap<String, String>();
        }
        this.translationDictionary.put(key, translationDictionaryItem);
        return this;
    }

    @Nullable
    public Map<String, String> getTranslationDictionary() {
        return this.translationDictionary;
    }

    public void setTranslationDictionary(@Nullable Map<String, String> translationDictionary) {
        this.translationDictionary = translationDictionary;
    }

    public TextDocumentFileRequest savingMode(@Nullable SavingModeEnum savingMode) {
        this.savingMode = savingMode;
        return this;
    }

    @Nullable
    public SavingModeEnum getSavingMode() {
        return this.savingMode;
    }

    public void setSavingMode(@Nullable SavingModeEnum savingMode) {
        this.savingMode = savingMode;
    }

    public TextDocumentFileRequest format(@Nonnull FormatEnum format) {
        this.format = format;
        return this;
    }

    @Nonnull
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(@Nonnull FormatEnum format) {
        this.format = format;
    }

    public TextDocumentFileRequest outputFormat(@Nonnull String outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    @Nonnull
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(@Nonnull String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public TextDocumentFileRequest preserveFormatting(@Nullable Boolean preserveFormatting) {
        this.preserveFormatting = preserveFormatting;
        return this;
    }

    @Nullable
    public Boolean getPreserveFormatting() {
        return this.preserveFormatting;
    }

    public void setPreserveFormatting(@Nullable Boolean preserveFormatting) {
        this.preserveFormatting = preserveFormatting;
    }

    public TextDocumentFileRequest origin(@Nullable String origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    public TextDocumentFileRequest pages(@Nullable List<Integer> pages) {
        this.pages = pages;
        return this;
    }

    public TextDocumentFileRequest addPagesItem(Integer pagesItem) {
        if (this.pages == null) {
            this.pages = new ArrayList<Integer>();
        }
        this.pages.add(pagesItem);
        return this;
    }

    @Nullable
    public List<Integer> getPages() {
        return this.pages;
    }

    public void setPages(@Nullable List<Integer> pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextDocumentFileRequest textDocumentFileRequest = (TextDocumentFileRequest)o;
        return Objects.equals(this.sourceLanguage, textDocumentFileRequest.sourceLanguage) && Objects.equals(this.targetLanguages, textDocumentFileRequest.targetLanguages) && Objects.equals(this.originalFileName, textDocumentFileRequest.originalFileName) && Objects.equals(this.url, textDocumentFileRequest.url) && Objects.equals(this.isNeedAlignment, textDocumentFileRequest.isNeedAlignment) && Objects.equals(this.translationDictionary, textDocumentFileRequest.translationDictionary) && Objects.equals((Object)this.savingMode, (Object)textDocumentFileRequest.savingMode) && Objects.equals((Object)this.format, (Object)textDocumentFileRequest.format) && Objects.equals(this.outputFormat, textDocumentFileRequest.outputFormat) && Objects.equals(this.preserveFormatting, textDocumentFileRequest.preserveFormatting) && Objects.equals(this.origin, textDocumentFileRequest.origin) && Objects.equals(this.pages, textDocumentFileRequest.pages);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceLanguage, this.targetLanguages, this.originalFileName, this.url, this.isNeedAlignment, this.translationDictionary, this.savingMode, this.format, this.outputFormat, this.preserveFormatting, this.origin, this.pages});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextDocumentFileRequest {\n");
        sb.append("    sourceLanguage: ").append(this.toIndentedString(this.sourceLanguage)).append("\n");
        sb.append("    targetLanguages: ").append(this.toIndentedString(this.targetLanguages)).append("\n");
        sb.append("    originalFileName: ").append(this.toIndentedString(this.originalFileName)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    isNeedAlignment: ").append(this.toIndentedString(this.isNeedAlignment)).append("\n");
        sb.append("    translationDictionary: ").append(this.toIndentedString(this.translationDictionary)).append("\n");
        sb.append("    savingMode: ").append(this.toIndentedString((Object)this.savingMode)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    outputFormat: ").append(this.toIndentedString(this.outputFormat)).append("\n");
        sb.append("    preserveFormatting: ").append(this.toIndentedString(this.preserveFormatting)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in TextDocumentFileRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TextDocumentFileRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceLanguage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `targetLanguages` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `originalFileName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAVING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `savingMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SAVING_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAVING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonNull()) {
            SavingModeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SAVING_MODE));
        }
        if (!jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `format` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORMAT).toString()));
        }
        FormatEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_FORMAT));
        if (!jsonObj.get(SERIALIZED_NAME_OUTPUT_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `outputFormat` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUTPUT_FORMAT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGIN) != null && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `origin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAGES) != null && !jsonObj.get(SERIALIZED_NAME_PAGES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PAGES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `pages` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAGES).toString()));
        }
    }

    public static TextDocumentFileRequest fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TextDocumentFileRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FormatEnum {
        UNKNOWN("Unknown"),
        DOC("Doc"),
        DOCX("Docx"),
        DOCM("Docm"),
        TXT("Txt"),
        RTF("Rtf"),
        ODT("Odt");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            FormatEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<FormatEnum> {
            @Override
            public void write(JsonWriter jsonWriter, FormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public FormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FormatEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SavingModeEnum {
        FILES("Files"),
        ARCHIVE("Archive"),
        BOTH("Both");

        private String value;

        private SavingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SavingModeEnum fromValue(String value) {
            for (SavingModeEnum b : SavingModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            SavingModeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<SavingModeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, SavingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public SavingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SavingModeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TextDocumentFileRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TextDocumentFileRequest> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TextDocumentFileRequest.class));
            return new TypeAdapter<TextDocumentFileRequest>(){

                @Override
                public void write(JsonWriter out, TextDocumentFileRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public TextDocumentFileRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    TextDocumentFileRequest.validateJsonElement(jsonElement);
                    return (TextDocumentFileRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

