/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class TextRequest {
    public static final String SERIALIZED_NAME_SOURCE_LANGUAGE = "sourceLanguage";
    @SerializedName(value="sourceLanguage")
    @Nullable
    private String sourceLanguage;
    public static final String SERIALIZED_NAME_TARGET_LANGUAGES = "targetLanguages";
    @SerializedName(value="targetLanguages")
    @Nullable
    private List<String> targetLanguages;
    public static final String SERIALIZED_NAME_TEXTS = "texts";
    @SerializedName(value="texts")
    @Nullable
    private List<String> texts;
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    @Nullable
    private String origin;
    public static final String SERIALIZED_NAME_CONTAINS_MARKDOWN = "containsMarkdown";
    @SerializedName(value="containsMarkdown")
    @Nullable
    private Boolean containsMarkdown;
    public static final String SERIALIZED_NAME_TRANSLATION_DICTIONARY = "translationDictionary";
    @SerializedName(value="translationDictionary")
    @Nullable
    private Map<String, String> translationDictionary;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("sourceLanguage", "targetLanguages", "texts", "origin", "containsMarkdown", "translationDictionary"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public TextRequest sourceLanguage(@Nullable String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
    }

    @Nullable
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(@Nullable String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public TextRequest targetLanguages(@Nullable List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
        return this;
    }

    public TextRequest addTargetLanguagesItem(String targetLanguagesItem) {
        if (this.targetLanguages == null) {
            this.targetLanguages = new ArrayList<String>();
        }
        this.targetLanguages.add(targetLanguagesItem);
        return this;
    }

    @Nullable
    public List<String> getTargetLanguages() {
        return this.targetLanguages;
    }

    public void setTargetLanguages(@Nullable List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
    }

    public TextRequest texts(@Nullable List<String> texts) {
        this.texts = texts;
        return this;
    }

    public TextRequest addTextsItem(String textsItem) {
        if (this.texts == null) {
            this.texts = new ArrayList<String>();
        }
        this.texts.add(textsItem);
        return this;
    }

    @Nullable
    public List<String> getTexts() {
        return this.texts;
    }

    public void setTexts(@Nullable List<String> texts) {
        this.texts = texts;
    }

    public TextRequest origin(@Nullable String origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    public TextRequest containsMarkdown(@Nullable Boolean containsMarkdown) {
        this.containsMarkdown = containsMarkdown;
        return this;
    }

    @Nullable
    public Boolean getContainsMarkdown() {
        return this.containsMarkdown;
    }

    public void setContainsMarkdown(@Nullable Boolean containsMarkdown) {
        this.containsMarkdown = containsMarkdown;
    }

    public TextRequest translationDictionary(@Nullable Map<String, String> translationDictionary) {
        this.translationDictionary = translationDictionary;
        return this;
    }

    public TextRequest putTranslationDictionaryItem(String key, String translationDictionaryItem) {
        if (this.translationDictionary == null) {
            this.translationDictionary = new HashMap<String, String>();
        }
        this.translationDictionary.put(key, translationDictionaryItem);
        return this;
    }

    @Nullable
    public Map<String, String> getTranslationDictionary() {
        return this.translationDictionary;
    }

    public void setTranslationDictionary(@Nullable Map<String, String> translationDictionary) {
        this.translationDictionary = translationDictionary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextRequest textRequest = (TextRequest)o;
        return Objects.equals(this.sourceLanguage, textRequest.sourceLanguage) && Objects.equals(this.targetLanguages, textRequest.targetLanguages) && Objects.equals(this.texts, textRequest.texts) && Objects.equals(this.origin, textRequest.origin) && Objects.equals(this.containsMarkdown, textRequest.containsMarkdown) && Objects.equals(this.translationDictionary, textRequest.translationDictionary);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.sourceLanguage, this.targetLanguages, this.texts, this.origin, this.containsMarkdown, this.translationDictionary);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextRequest {\n");
        sb.append("    sourceLanguage: ").append(this.toIndentedString(this.sourceLanguage)).append("\n");
        sb.append("    targetLanguages: ").append(this.toIndentedString(this.targetLanguages)).append("\n");
        sb.append("    texts: ").append(this.toIndentedString(this.texts)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    containsMarkdown: ").append(this.toIndentedString(this.containsMarkdown)).append("\n");
        sb.append("    translationDictionary: ").append(this.toIndentedString(this.translationDictionary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in TextRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TextRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceLanguage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `targetLanguages` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TEXTS) != null && !jsonObj.get(SERIALIZED_NAME_TEXTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TEXTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `texts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEXTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGIN) != null && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `origin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGIN).toString()));
        }
    }

    public static TextRequest fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TextRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TextRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TextRequest> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TextRequest.class));
            return new TypeAdapter<TextRequest>(){

                @Override
                public void write(JsonWriter out, TextRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public TextRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    TextRequest.validateJsonElement(jsonElement);
                    return (TextRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

