/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class XmlFileRequest {
    public static final String SERIALIZED_NAME_SOURCE_LANGUAGE = "sourceLanguage";
    @SerializedName(value="sourceLanguage")
    @Nonnull
    private String sourceLanguage = "en";
    public static final String SERIALIZED_NAME_TARGET_LANGUAGES = "targetLanguages";
    @SerializedName(value="targetLanguages")
    @Nonnull
    private List<String> targetLanguages = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ORIGINAL_FILE_NAME = "originalFileName";
    @SerializedName(value="originalFileName")
    @Nullable
    private String originalFileName;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    @Nonnull
    private String url;
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    @Nullable
    private String origin;
    public static final String SERIALIZED_NAME_IS_NEED_ALIGNMENT = "isNeedAlignment";
    @SerializedName(value="isNeedAlignment")
    @Nullable
    private Boolean isNeedAlignment;
    public static final String SERIALIZED_NAME_TRANSLATION_DICTIONARY = "translationDictionary";
    @SerializedName(value="translationDictionary")
    @Nullable
    private Map<String, String> translationDictionary;
    public static final String SERIALIZED_NAME_SAVING_MODE = "savingMode";
    @SerializedName(value="savingMode")
    @Nullable
    private SavingModeEnum savingMode;
    public static final String SERIALIZED_NAME_IGNORE_LIST = "ignoreList";
    @SerializedName(value="ignoreList")
    @Nullable
    private List<String> ignoreList;
    public static final String SERIALIZED_NAME_IS_WHITE_LIST = "isWhiteList";
    @SerializedName(value="isWhiteList")
    @Nullable
    private Boolean isWhiteList;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("sourceLanguage", "targetLanguages", "originalFileName", "url", "origin", "isNeedAlignment", "translationDictionary", "savingMode", "ignoreList", "isWhiteList"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("sourceLanguage", "targetLanguages", "url"));

    public XmlFileRequest sourceLanguage(@Nonnull String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
    }

    @Nonnull
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(@Nonnull String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public XmlFileRequest targetLanguages(@Nonnull List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
        return this;
    }

    public XmlFileRequest addTargetLanguagesItem(String targetLanguagesItem) {
        if (this.targetLanguages == null) {
            this.targetLanguages = new ArrayList<String>();
        }
        this.targetLanguages.add(targetLanguagesItem);
        return this;
    }

    @Nonnull
    public List<String> getTargetLanguages() {
        return this.targetLanguages;
    }

    public void setTargetLanguages(@Nonnull List<String> targetLanguages) {
        this.targetLanguages = targetLanguages;
    }

    public XmlFileRequest originalFileName(@Nullable String originalFileName) {
        this.originalFileName = originalFileName;
        return this;
    }

    @Nullable
    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public void setOriginalFileName(@Nullable String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public XmlFileRequest url(@Nonnull String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nonnull String url) {
        this.url = url;
    }

    public XmlFileRequest origin(@Nullable String origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    public XmlFileRequest isNeedAlignment(@Nullable Boolean isNeedAlignment) {
        this.isNeedAlignment = isNeedAlignment;
        return this;
    }

    @Nullable
    public Boolean getIsNeedAlignment() {
        return this.isNeedAlignment;
    }

    public void setIsNeedAlignment(@Nullable Boolean isNeedAlignment) {
        this.isNeedAlignment = isNeedAlignment;
    }

    public XmlFileRequest translationDictionary(@Nullable Map<String, String> translationDictionary) {
        this.translationDictionary = translationDictionary;
        return this;
    }

    public XmlFileRequest putTranslationDictionaryItem(String key, String translationDictionaryItem) {
        if (this.translationDictionary == null) {
            this.translationDictionary = new HashMap<String, String>();
        }
        this.translationDictionary.put(key, translationDictionaryItem);
        return this;
    }

    @Nullable
    public Map<String, String> getTranslationDictionary() {
        return this.translationDictionary;
    }

    public void setTranslationDictionary(@Nullable Map<String, String> translationDictionary) {
        this.translationDictionary = translationDictionary;
    }

    public XmlFileRequest savingMode(@Nullable SavingModeEnum savingMode) {
        this.savingMode = savingMode;
        return this;
    }

    @Nullable
    public SavingModeEnum getSavingMode() {
        return this.savingMode;
    }

    public void setSavingMode(@Nullable SavingModeEnum savingMode) {
        this.savingMode = savingMode;
    }

    public XmlFileRequest ignoreList(@Nullable List<String> ignoreList) {
        this.ignoreList = ignoreList;
        return this;
    }

    public XmlFileRequest addIgnoreListItem(String ignoreListItem) {
        if (this.ignoreList == null) {
            this.ignoreList = new ArrayList<String>();
        }
        this.ignoreList.add(ignoreListItem);
        return this;
    }

    @Nullable
    public List<String> getIgnoreList() {
        return this.ignoreList;
    }

    public void setIgnoreList(@Nullable List<String> ignoreList) {
        this.ignoreList = ignoreList;
    }

    public XmlFileRequest isWhiteList(@Nullable Boolean isWhiteList) {
        this.isWhiteList = isWhiteList;
        return this;
    }

    @Nullable
    public Boolean getIsWhiteList() {
        return this.isWhiteList;
    }

    public void setIsWhiteList(@Nullable Boolean isWhiteList) {
        this.isWhiteList = isWhiteList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlFileRequest xmlFileRequest = (XmlFileRequest)o;
        return Objects.equals(this.sourceLanguage, xmlFileRequest.sourceLanguage) && Objects.equals(this.targetLanguages, xmlFileRequest.targetLanguages) && Objects.equals(this.originalFileName, xmlFileRequest.originalFileName) && Objects.equals(this.url, xmlFileRequest.url) && Objects.equals(this.origin, xmlFileRequest.origin) && Objects.equals(this.isNeedAlignment, xmlFileRequest.isNeedAlignment) && Objects.equals(this.translationDictionary, xmlFileRequest.translationDictionary) && Objects.equals((Object)this.savingMode, (Object)xmlFileRequest.savingMode) && Objects.equals(this.ignoreList, xmlFileRequest.ignoreList) && Objects.equals(this.isWhiteList, xmlFileRequest.isWhiteList);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceLanguage, this.targetLanguages, this.originalFileName, this.url, this.origin, this.isNeedAlignment, this.translationDictionary, this.savingMode, this.ignoreList, this.isWhiteList});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XmlFileRequest {\n");
        sb.append("    sourceLanguage: ").append(this.toIndentedString(this.sourceLanguage)).append("\n");
        sb.append("    targetLanguages: ").append(this.toIndentedString(this.targetLanguages)).append("\n");
        sb.append("    originalFileName: ").append(this.toIndentedString(this.originalFileName)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    isNeedAlignment: ").append(this.toIndentedString(this.isNeedAlignment)).append("\n");
        sb.append("    translationDictionary: ").append(this.toIndentedString(this.translationDictionary)).append("\n");
        sb.append("    savingMode: ").append(this.toIndentedString((Object)this.savingMode)).append("\n");
        sb.append("    ignoreList: ").append(this.toIndentedString(this.ignoreList)).append("\n");
        sb.append("    isWhiteList: ").append(this.toIndentedString(this.isWhiteList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in XmlFileRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `XmlFileRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceLanguage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `targetLanguages` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_LANGUAGES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `originalFileName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_FILE_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGIN) != null && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `origin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAVING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `savingMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SAVING_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAVING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonNull()) {
            SavingModeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SAVING_MODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_IGNORE_LIST) != null && !jsonObj.get(SERIALIZED_NAME_IGNORE_LIST).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IGNORE_LIST).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `ignoreList` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IGNORE_LIST).toString()));
        }
    }

    public static XmlFileRequest fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, XmlFileRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SavingModeEnum {
        FILES("Files"),
        ARCHIVE("Archive"),
        BOTH("Both");

        private String value;

        private SavingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SavingModeEnum fromValue(String value) {
            for (SavingModeEnum b : SavingModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            SavingModeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<SavingModeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, SavingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public SavingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SavingModeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!XmlFileRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<XmlFileRequest> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(XmlFileRequest.class));
            return new TypeAdapter<XmlFileRequest>(){

                @Override
                public void write(JsonWriter out, XmlFileRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public XmlFileRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    XmlFileRequest.validateJsonElement(jsonElement);
                    return (XmlFileRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

