/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.time.Duration;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.junit.platform.commons.util.ExceptionUtils;

class AssertTimeout {
    private AssertTimeout() {
    }

    static void assertTimeout(Duration timeout2, Executable executable) {
        AssertTimeout.assertTimeout(timeout2, executable, (String)null);
    }

    static void assertTimeout(Duration timeout2, Executable executable, String message) {
        AssertTimeout.assertTimeout(timeout2, () -> {
            executable.execute();
            return null;
        }, message);
    }

    static void assertTimeout(Duration timeout2, Executable executable, Supplier<String> messageSupplier) {
        AssertTimeout.assertTimeout(timeout2, () -> {
            executable.execute();
            return null;
        }, messageSupplier);
    }

    static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier) {
        return AssertTimeout.assertTimeout(timeout2, supplier, null);
    }

    static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier, String message) {
        return AssertTimeout.assertTimeout(timeout2, supplier, (Object)message);
    }

    static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        return AssertTimeout.assertTimeout(timeout2, supplier, messageSupplier);
    }

    private static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier, Object messageOrSupplier) {
        long timeoutInMillis = timeout2.toMillis();
        long start = System.currentTimeMillis();
        T result = null;
        try {
            result = supplier.get();
        }
        catch (Throwable ex) {
            ExceptionUtils.throwAsUncheckedException(ex);
        }
        long timeElapsed = System.currentTimeMillis() - start;
        if (timeElapsed > timeoutInMillis) {
            AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("execution exceeded timeout of " + timeoutInMillis + " ms by " + (timeElapsed - timeoutInMillis) + " ms").buildAndThrow();
        }
        return result;
    }
}

