/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.extension.DisabledCondition;
import org.junit.jupiter.engine.extension.ExtensionRegistrar;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.jupiter.engine.extension.RepeatedTestExtension;
import org.junit.jupiter.engine.extension.TempDirectory;
import org.junit.jupiter.engine.extension.TestInfoParameterResolver;
import org.junit.jupiter.engine.extension.TestReporterParameterResolver;
import org.junit.jupiter.engine.extension.TimeoutExtension;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.5")
public class MutableExtensionRegistry
implements ExtensionRegistry,
ExtensionRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(MutableExtensionRegistry.class);
    private static final List<Extension> DEFAULT_STATELESS_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(new DisabledCondition(), new TimeoutExtension(), new RepeatedTestExtension(), new TestInfoParameterResolver(), new TestReporterParameterResolver()));
    private final MutableExtensionRegistry parent;
    private final Set<Class<? extends Extension>> registeredExtensionTypes = new LinkedHashSet<Class<? extends Extension>>();
    private final List<Extension> registeredExtensions = new ArrayList<Extension>();

    public static MutableExtensionRegistry createRegistryWithDefaultExtensions(JupiterConfiguration configuration) {
        MutableExtensionRegistry extensionRegistry = new MutableExtensionRegistry(null);
        DEFAULT_STATELESS_EXTENSIONS.forEach(extensionRegistry::registerDefaultExtension);
        extensionRegistry.registerDefaultExtension(new TempDirectory(configuration));
        if (configuration.isExtensionAutoDetectionEnabled()) {
            MutableExtensionRegistry.registerAutoDetectedExtensions(extensionRegistry);
        }
        return extensionRegistry;
    }

    private static void registerAutoDetectedExtensions(MutableExtensionRegistry extensionRegistry) {
        ServiceLoader.load(Extension.class, ClassLoaderUtils.getDefaultClassLoader()).forEach(extensionRegistry::registerAutoDetectedExtension);
    }

    public static MutableExtensionRegistry createRegistryFrom(MutableExtensionRegistry parentRegistry, Stream<Class<? extends Extension>> extensionTypes) {
        Preconditions.notNull(parentRegistry, "parentRegistry must not be null");
        MutableExtensionRegistry registry = new MutableExtensionRegistry(parentRegistry);
        extensionTypes.forEach(registry::registerExtension);
        return registry;
    }

    private MutableExtensionRegistry(MutableExtensionRegistry parent) {
        this.parent = parent;
    }

    @Override
    public <E extends Extension> Stream<E> stream(Class<E> extensionType) {
        if (this.parent == null) {
            return this.streamLocal(extensionType);
        }
        return Stream.concat(this.parent.stream(extensionType), this.streamLocal(extensionType));
    }

    private <E extends Extension> Stream<E> streamLocal(Class<E> extensionType) {
        return this.registeredExtensions.stream().filter(extensionType::isInstance).map(extensionType::cast);
    }

    @Override
    public void registerExtension(Class<? extends Extension> extensionType) {
        if (!this.isAlreadyRegistered(extensionType)) {
            this.registerLocalExtension(ReflectionUtils.newInstance(extensionType, new Object[0]));
        }
    }

    private boolean isAlreadyRegistered(Class<? extends Extension> extensionType) {
        return this.registeredExtensionTypes.contains(extensionType) || this.parent != null && this.parent.isAlreadyRegistered(extensionType);
    }

    @Override
    public void registerExtension(Extension extension, Object source2) {
        Preconditions.notNull(source2, "source must not be null");
        this.registerExtension("local", extension, source2);
    }

    @Override
    public void registerSyntheticExtension(Extension extension, Object source2) {
        this.registerExtension("synthetic", extension, source2);
    }

    private void registerDefaultExtension(Extension extension) {
        this.registerExtension("default", extension);
    }

    private void registerAutoDetectedExtension(Extension extension) {
        this.registerExtension("auto-detected", extension);
    }

    private void registerLocalExtension(Extension extension) {
        this.registerExtension("local", extension);
    }

    private void registerExtension(String category, Extension extension) {
        this.registerExtension(category, extension, null);
    }

    private void registerExtension(String category, Extension extension, Object source2) {
        Preconditions.notBlank(category, "category must not be null or blank");
        Preconditions.notNull(extension, "Extension must not be null");
        logger.trace(() -> String.format("Registering %s extension [%s]%s", category, extension, this.buildSourceInfo(source2)));
        this.registeredExtensions.add(extension);
        this.registeredExtensionTypes.add(extension.getClass());
    }

    private String buildSourceInfo(Object source2) {
        if (source2 == null) {
            return "";
        }
        if (source2 instanceof Member) {
            Member member = (Member)source2;
            String type = member instanceof Method ? "method" : "field";
            source2 = String.format("%s %s.%s", type, member.getDeclaringClass().getName(), member.getName());
        }
        return " from source [" + source2 + "]";
    }
}

