/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.extension.SameThreadTimeoutInvocation;
import org.junit.jupiter.engine.extension.SeparateThreadTimeoutInvocation;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;

class TimeoutInvocationFactory {
    private final ExtensionContext.Store store;

    TimeoutInvocationFactory(ExtensionContext.Store store) {
        this.store = Preconditions.notNull(store, "store must not be null");
    }

    <T> InvocationInterceptor.Invocation<T> create(Timeout.ThreadMode threadMode, TimeoutInvocationParameters<T> timeoutInvocationParameters) {
        Preconditions.notNull(threadMode, "thread mode must not be null");
        Preconditions.condition(threadMode != Timeout.ThreadMode.INFERRED, "thread mode must not be INFERRED");
        Preconditions.notNull(timeoutInvocationParameters, "timeout invocation parameters must not be null");
        if (threadMode == Timeout.ThreadMode.SEPARATE_THREAD) {
            return new SeparateThreadTimeoutInvocation<T>(timeoutInvocationParameters.getInvocation(), timeoutInvocationParameters.getTimeoutDuration(), timeoutInvocationParameters.getDescriptionSupplier());
        }
        return new SameThreadTimeoutInvocation<T>(timeoutInvocationParameters.getInvocation(), timeoutInvocationParameters.getTimeoutDuration(), this.getThreadExecutorForSameThreadInvocation(), timeoutInvocationParameters.getDescriptionSupplier());
    }

    private ScheduledExecutorService getThreadExecutorForSameThreadInvocation() {
        return this.store.getOrComputeIfAbsent(SingleThreadExecutorResource.class).get();
    }

    static class TimeoutInvocationParameters<T> {
        private final InvocationInterceptor.Invocation<T> invocation;
        private final TimeoutDuration timeout;
        private final Supplier<String> descriptionSupplier;

        TimeoutInvocationParameters(InvocationInterceptor.Invocation<T> invocation, TimeoutDuration timeout2, Supplier<String> descriptionSupplier) {
            this.invocation = Preconditions.notNull(invocation, "invocation must not be null");
            this.timeout = Preconditions.notNull(timeout2, "timeout must not be null");
            this.descriptionSupplier = Preconditions.notNull(descriptionSupplier, "description supplier must not be null");
        }

        public InvocationInterceptor.Invocation<T> getInvocation() {
            return this.invocation;
        }

        public TimeoutDuration getTimeoutDuration() {
            return this.timeout;
        }

        public Supplier<String> getDescriptionSupplier() {
            return this.descriptionSupplier;
        }
    }

    static class SingleThreadExecutorResource
    extends ExecutorResource {
        SingleThreadExecutorResource() {
            super(Executors.newSingleThreadScheduledExecutor(runnable2 -> {
                Thread thread2 = new Thread(runnable2, "junit-jupiter-timeout-watcher");
                thread2.setPriority(10);
                return thread2;
            }));
        }
    }

    private static abstract class ExecutorResource
    implements ExtensionContext.Store.CloseableResource {
        protected final ScheduledExecutorService executor;

        ExecutorResource(ScheduledExecutorService executor) {
            this.executor = executor;
        }

        ScheduledExecutorService get() {
            return this.executor;
        }

        @Override
        public void close() throws Throwable {
            this.executor.shutdown();
            boolean terminated = this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            if (!terminated) {
                this.executor.shutdownNow();
                throw new JUnitException("Scheduled executor could not be stopped in an orderly manner");
            }
        }
    }
}

