/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.invocation.InterceptedInvocation;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.RealMethod;
import org.mockito.internal.invocation.SerializableMethod;
import org.mockito.internal.invocation.mockref.MockWeakReference;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.InvocationFactory;
import org.mockito.invocation.Location;
import org.mockito.mock.MockCreationSettings;

public class DefaultInvocationFactory
implements InvocationFactory {
    @Override
    public Invocation createInvocation(Object target, MockCreationSettings settings, Method method, Callable realMethod, Object ... args2) {
        RealMethod.FromCallable superMethod = new RealMethod.FromCallable(realMethod);
        return this.createInvocation(target, settings, method, superMethod, args2);
    }

    @Override
    public Invocation createInvocation(Object target, MockCreationSettings settings, Method method, InvocationFactory.RealMethodBehavior realMethod, Object ... args2) {
        RealMethod.FromBehavior superMethod = new RealMethod.FromBehavior(realMethod);
        return this.createInvocation(target, settings, method, superMethod, args2);
    }

    private Invocation createInvocation(Object target, MockCreationSettings settings, Method method, RealMethod superMethod, Object[] args2) {
        return DefaultInvocationFactory.createInvocation(target, method, args2, superMethod, settings);
    }

    public static InterceptedInvocation createInvocation(Object mock, Method invokedMethod, Object[] arguments, RealMethod realMethod, MockCreationSettings settings, Location location) {
        return new InterceptedInvocation(new MockWeakReference<Object>(mock), DefaultInvocationFactory.createMockitoMethod(invokedMethod, settings), arguments, realMethod, location, SequenceNumber.next());
    }

    private static InterceptedInvocation createInvocation(Object mock, Method invokedMethod, Object[] arguments, RealMethod realMethod, MockCreationSettings settings) {
        return DefaultInvocationFactory.createInvocation(mock, invokedMethod, arguments, realMethod, settings, new LocationImpl());
    }

    private static MockitoMethod createMockitoMethod(Method method, MockCreationSettings settings) {
        if (settings.isSerializable()) {
            return new SerializableMethod(method);
        }
        return new DelegatingMethod(method);
    }
}

