/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.hamcrest.HamcrestArgumentMatcher;
import org.mockito.internal.invocation.ArgumentMatcherAction;
import org.mockito.internal.matchers.VarargMatcher;
import org.mockito.invocation.Invocation;

public class MatcherApplicationStrategy {
    private final Invocation invocation;
    private final List<ArgumentMatcher<?>> matchers;
    private final MatcherApplicationType matchingType;

    private MatcherApplicationStrategy(Invocation invocation, List<ArgumentMatcher<?>> matchers, MatcherApplicationType matchingType) {
        this.invocation = invocation;
        if (matchingType == MatcherApplicationType.MATCH_EACH_VARARGS_WITH_LAST_MATCHER) {
            int times = MatcherApplicationStrategy.varargLength(invocation);
            this.matchers = MatcherApplicationStrategy.appendLastMatcherNTimes(matchers, times);
        } else {
            this.matchers = matchers;
        }
        this.matchingType = matchingType;
    }

    public static MatcherApplicationStrategy getMatcherApplicationStrategyFor(Invocation invocation, List<ArgumentMatcher<?>> matchers) {
        MatcherApplicationType type = MatcherApplicationStrategy.getMatcherApplicationType(invocation, matchers);
        return new MatcherApplicationStrategy(invocation, matchers, type);
    }

    public boolean forEachMatcherAndArgument(ArgumentMatcherAction action) {
        if (this.matchingType == MatcherApplicationType.ERROR_UNSUPPORTED_NUMBER_OF_MATCHERS) {
            return false;
        }
        Object[] arguments = this.invocation.getArguments();
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            Object argument;
            ArgumentMatcher<?> matcher = this.matchers.get(i2);
            if (action.apply(matcher, argument = arguments[i2])) continue;
            return false;
        }
        return true;
    }

    private static MatcherApplicationType getMatcherApplicationType(Invocation invocation, List<ArgumentMatcher<?>> matchers) {
        int matcherCount;
        int rawArguments = invocation.getRawArguments().length;
        int expandedArguments = invocation.getArguments().length;
        if (expandedArguments == (matcherCount = matchers.size())) {
            return MatcherApplicationType.ONE_MATCHER_PER_ARGUMENT;
        }
        if (rawArguments == matcherCount && MatcherApplicationStrategy.isLastMatcherVarargMatcher(matchers)) {
            return MatcherApplicationType.MATCH_EACH_VARARGS_WITH_LAST_MATCHER;
        }
        return MatcherApplicationType.ERROR_UNSUPPORTED_NUMBER_OF_MATCHERS;
    }

    private static boolean isLastMatcherVarargMatcher(List<ArgumentMatcher<?>> matchers) {
        ArgumentMatcher<?> argumentMatcher = MatcherApplicationStrategy.lastMatcher(matchers);
        if (argumentMatcher instanceof HamcrestArgumentMatcher) {
            return ((HamcrestArgumentMatcher)argumentMatcher).isVarargMatcher();
        }
        return argumentMatcher instanceof VarargMatcher;
    }

    private static List<ArgumentMatcher<?>> appendLastMatcherNTimes(List<ArgumentMatcher<?>> matchers, int timesToAppendLastMatcher) {
        ArgumentMatcher<?> lastMatcher = MatcherApplicationStrategy.lastMatcher(matchers);
        ArrayList expandedMatchers = new ArrayList(matchers);
        for (int i2 = 0; i2 < timesToAppendLastMatcher; ++i2) {
            expandedMatchers.add(lastMatcher);
        }
        return expandedMatchers;
    }

    private static int varargLength(Invocation invocation) {
        int rawArgumentCount = invocation.getRawArguments().length;
        int expandedArgumentCount = invocation.getArguments().length;
        return expandedArgumentCount - rawArgumentCount;
    }

    private static ArgumentMatcher<?> lastMatcher(List<ArgumentMatcher<?>> matchers) {
        return matchers.get(matchers.size() - 1);
    }

    static enum MatcherApplicationType {
        ONE_MATCHER_PER_ARGUMENT,
        MATCH_EACH_VARARGS_WITH_LAST_MATCHER,
        ERROR_UNSUPPORTED_NUMBER_OF_MATCHERS;

    }
}

