/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.viewer.client.ApiCallback;
import com.groupdocs.cloud.viewer.client.ApiClient;
import com.groupdocs.cloud.viewer.client.ApiException;
import com.groupdocs.cloud.viewer.client.ApiResponse;
import com.groupdocs.cloud.viewer.client.Configuration;
import com.groupdocs.cloud.viewer.client.Pair;
import com.groupdocs.cloud.viewer.client.ProgressRequestBody;
import com.groupdocs.cloud.viewer.client.ProgressResponseBody;
import com.groupdocs.cloud.viewer.model.DeleteViewOptions;
import com.groupdocs.cloud.viewer.model.ViewOptions;
import com.groupdocs.cloud.viewer.model.ViewResult;
import com.groupdocs.cloud.viewer.model.requests.ConvertAndDownloadRequest;
import com.groupdocs.cloud.viewer.model.requests.CreateViewRequest;
import com.groupdocs.cloud.viewer.model.requests.DeleteViewRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ViewApi {
    private ApiClient apiClient;

    public ViewApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public ViewApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call convertAndDownloadCall(ConvertAndDownloadRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/viewer/convertAndDownload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getformat() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("format", request.getformat()));
        }
        if (request.getpages() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pages", request.getpages()));
        }
        if (request.getpassword() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("password", request.getpassword()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (request.getFile() != null) {
            localVarFormParams.put("File", request.getFile());
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call convertAndDownloadValidateBeforeCall(ConvertAndDownloadRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getformat() == null) {
            throw new ApiException("Missing the required parameter 'format' when calling convertAndDownload(Async)");
        }
        if (request.getFile() == null) {
            throw new ApiException("Missing the required parameter 'file' when calling convertAndDownload(Async)");
        }
        Call call = this.convertAndDownloadCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File convertAndDownload(ConvertAndDownloadRequest request) throws ApiException {
        ApiResponse<File> resp = this.convertAndDownloadWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<File> convertAndDownloadWithHttpInfo(ConvertAndDownloadRequest request) throws ApiException {
        Call call = this.convertAndDownloadValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call convertAndDownloadAsync(ConvertAndDownloadRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.convertAndDownloadValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createViewCall(CreateViewRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ViewOptions localVarPostBody = request.getviewOptions();
        String localVarPath = "/viewer/view";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createViewValidateBeforeCall(CreateViewRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getviewOptions() == null) {
            throw new ApiException("Missing the required parameter 'viewOptions' when calling createView(Async)");
        }
        Call call = this.createViewCall(request, progressListener, progressRequestListener);
        return call;
    }

    public ViewResult createView(CreateViewRequest request) throws ApiException {
        ApiResponse<ViewResult> resp = this.createViewWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<ViewResult> createViewWithHttpInfo(CreateViewRequest request) throws ApiException {
        Call call = this.createViewValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<ViewResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createViewAsync(CreateViewRequest request, final ApiCallback<ViewResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createViewValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ViewResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteViewCall(DeleteViewRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeleteViewOptions localVarPostBody = request.getdeleteViewOptions();
        String localVarPath = "/viewer/view";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteViewValidateBeforeCall(DeleteViewRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getdeleteViewOptions() == null) {
            throw new ApiException("Missing the required parameter 'deleteViewOptions' when calling deleteView(Async)");
        }
        Call call = this.deleteViewCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void deleteView(DeleteViewRequest request) throws ApiException {
        this.deleteViewWithHttpInfo(request);
    }

    public ApiResponse<Void> deleteViewWithHttpInfo(DeleteViewRequest request) throws ApiException {
        Call call = this.deleteViewValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteViewAsync(DeleteViewRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteViewValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

