/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.viewer.model.Tile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Rendering options for CAD file formats. CAD file formats include files with extensions: .dwg, .dxf, .dgn, .ifc, .stl")
public class CadOptions {
    @SerializedName(value="scaleFactor")
    private Double scaleFactor = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="tiles")
    private List<Tile> tiles = null;
    @SerializedName(value="renderLayouts")
    private Boolean renderLayouts = null;
    @SerializedName(value="layoutName")
    private String layoutName = null;
    @SerializedName(value="layers")
    private List<String> layers = null;

    public CadOptions scaleFactor(Double scaleFactor) {
        this.scaleFactor = scaleFactor;
        return this;
    }

    @ApiModelProperty(required=true, value="Scale factor allows to change the size of the output document. Values higher than 1 will enlarge output result and values between 0 and 1 will make output result smaller. This option is ignored when either Height or Width options are set. ")
    public Double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(Double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public CadOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Width of the output result in pixels        ")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public CadOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Height of the output result in pixels     ")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public CadOptions tiles(List<Tile> tiles) {
        this.tiles = tiles;
        return this;
    }

    public CadOptions addTilesItem(Tile tilesItem) {
        if (this.tiles == null) {
            this.tiles = new ArrayList<Tile>();
        }
        this.tiles.add(tilesItem);
        return this;
    }

    @ApiModelProperty(value="The drawing regions to render This option supported only for DWG and DWT file types The RenderLayouts and LayoutName options are ignored when rendering by tiles")
    public List<Tile> getTiles() {
        return this.tiles;
    }

    public void setTiles(List<Tile> tiles) {
        this.tiles = tiles;
    }

    public CadOptions renderLayouts(Boolean renderLayouts) {
        this.renderLayouts = renderLayouts;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether layouts from CAD document should be rendered")
    public Boolean getRenderLayouts() {
        return this.renderLayouts;
    }

    public void setRenderLayouts(Boolean renderLayouts) {
        this.renderLayouts = renderLayouts;
    }

    public CadOptions layoutName(String layoutName) {
        this.layoutName = layoutName;
        return this;
    }

    @ApiModelProperty(value="The name of the specific layout to render. Layout name is case-sensitive")
    public String getLayoutName() {
        return this.layoutName;
    }

    public void setLayoutName(String layoutName) {
        this.layoutName = layoutName;
    }

    public CadOptions layers(List<String> layers) {
        this.layers = layers;
        return this;
    }

    public CadOptions addLayersItem(String layersItem) {
        if (this.layers == null) {
            this.layers = new ArrayList<String>();
        }
        this.layers.add(layersItem);
        return this;
    }

    @ApiModelProperty(value="The CAD drawing layers to render By default all layers are rendered; Layer names are case-sensitive")
    public List<String> getLayers() {
        return this.layers;
    }

    public void setLayers(List<String> layers) {
        this.layers = layers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CadOptions cadOptions = (CadOptions)o;
        return Objects.equals(this.scaleFactor, cadOptions.scaleFactor) && Objects.equals(this.width, cadOptions.width) && Objects.equals(this.height, cadOptions.height) && Objects.equals(this.tiles, cadOptions.tiles) && Objects.equals(this.renderLayouts, cadOptions.renderLayouts) && Objects.equals(this.layoutName, cadOptions.layoutName) && Objects.equals(this.layers, cadOptions.layers);
    }

    public int hashCode() {
        return Objects.hash(this.scaleFactor, this.width, this.height, this.tiles, this.renderLayouts, this.layoutName, this.layers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CadOptions {\n");
        sb.append("    scaleFactor: ").append(this.toIndentedString(this.scaleFactor)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    tiles: ").append(this.toIndentedString(this.tiles)).append("\n");
        sb.append("    renderLayouts: ").append(this.toIndentedString(this.renderLayouts)).append("\n");
        sb.append("    layoutName: ").append(this.toIndentedString(this.layoutName)).append("\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

