/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.viewer.model.Layer;
import com.groupdocs.cloud.viewer.model.Layout;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents view information for CAD drawing")
public class CadViewInfo {
    @SerializedName(value="layers")
    private List<Layer> layers = null;
    @SerializedName(value="layouts")
    private List<Layout> layouts = null;

    public CadViewInfo layers(List<Layer> layers) {
        this.layers = layers;
        return this;
    }

    public CadViewInfo addLayersItem(Layer layersItem) {
        if (this.layers == null) {
            this.layers = new ArrayList<Layer>();
        }
        this.layers.add(layersItem);
        return this;
    }

    @ApiModelProperty(value="The list of layers contained by the CAD drawing")
    public List<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    public CadViewInfo layouts(List<Layout> layouts) {
        this.layouts = layouts;
        return this;
    }

    public CadViewInfo addLayoutsItem(Layout layoutsItem) {
        if (this.layouts == null) {
            this.layouts = new ArrayList<Layout>();
        }
        this.layouts.add(layoutsItem);
        return this;
    }

    @ApiModelProperty(value="The list of layouts contained by the CAD drawing")
    public List<Layout> getLayouts() {
        return this.layouts;
    }

    public void setLayouts(List<Layout> layouts) {
        this.layouts = layouts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CadViewInfo cadViewInfo = (CadViewInfo)o;
        return Objects.equals(this.layers, cadViewInfo.layers) && Objects.equals(this.layouts, cadViewInfo.layouts);
    }

    public int hashCode() {
        return Objects.hash(this.layers, this.layouts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CadViewInfo {\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("    layouts: ").append(this.toIndentedString(this.layouts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

