/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.viewer.model.FieldLabel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Rendering options for Email file formats. Email file formats include files with extensions: .msg, .eml, .emlx, .ifc, .stl")
public class EmailOptions {
    @SerializedName(value="pageSize")
    private PageSizeEnum pageSize = null;
    @SerializedName(value="fieldLabels")
    private List<FieldLabel> fieldLabels = null;
    @SerializedName(value="dateTimeFormat")
    private String dateTimeFormat = null;
    @SerializedName(value="timeZoneOffset")
    private String timeZoneOffset = null;

    public EmailOptions pageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(required=true, value="The size of the output page when rendering as PDF or image.")
    public PageSizeEnum getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
    }

    public EmailOptions fieldLabels(List<FieldLabel> fieldLabels) {
        this.fieldLabels = fieldLabels;
        return this;
    }

    public EmailOptions addFieldLabelsItem(FieldLabel fieldLabelsItem) {
        if (this.fieldLabels == null) {
            this.fieldLabels = new ArrayList<FieldLabel>();
        }
        this.fieldLabels.add(fieldLabelsItem);
        return this;
    }

    @ApiModelProperty(value="The list of supported email message field labels: 1. Field: \"Anniversary\" - default label is \"Anniversary\". 2. Field: \"Attachments\" - default label is \"Attachments\". 3. Field: \"Bcc\" - default label is \"Bcc\". 4. Field: \"Birthday\" - default label is \"Birthday\". 5. Field: \"Business\" - default label is \"Business\". 6. Field: \"BusinessAddress\" - default label is \"Business Address\". 7. Field: \"BusinessFax\" - default label is \"Business Fax\". 8. Field: \"BusinessHomepage\" - default label is \"BusinessHomePage\". 9. Field: \"Cc\" - default label is \"Cc\". 10. Field: \"Company\" - default label is \"Company\". 11. Field: \"Department\" - default label is \"Department\". 12. Field: \"Email\" - default label is \"Email\". 13. Field: \"EmailDisplayAs\" - default label is \"Email Display As\". 14. Field: \"Email2\" - default label is \"Email2\". 15. Field: \"Email2DisplayAs\" - default label is \"Email2 Display As\". 16. Field: \"Email3\" - default label is \"Email3\". 17. Field: \"Email3DisplayAs\" - default label is \"Email3 Display As\". 18. Field: \"End\" - default label is \"End\". 19. Field: \"FirstName\" - default label is \"First Name\". 20. Field: \"From\" - default label is \"From\". 21. Field: \"FullName\" - default label is \"Full Name\". 22. Field: \"Gender\" - default label is \"Gender\". 23. Field: \"Hobbies\" - default label is \"Hobbies\". 24. Field: \"Home\" - default label is \"Home\". 25. Field: \"HomeAddress\" - default label is \"Home Address\". 26. Field: \"Importance\" - default label is \"Importance\". 27. Field: \"JobTitle\" - default label is \"Job Title\". 28. Field: \"LastName\" - default label is \"Last Name\". 29. Field: \"Location\" - default label is \"Location\". 30. Field: \"MiddleName\" - default label is \"Middle Name\". 31. Field: \"Mobile\" - default label is \"Mobile\". 32. Field: \"Organizer\" - default label is \"Organizer\". 33. Field: \"OtherAddress\" - default label is \"Other Address\". 34. Field: \"PersonalHomepage\" - default label is \"PersonalHomePage\". 35. Field: \"Profession\" - default label is \"Profession\". 36. Field: \"Recurrence\" - default label is \"Recurrence\". 37. Field: \"RecurrencePattern\" - default label is \"Recurrence Pattern\". 38. Field: \"RequiredAttendees\" - default label is \"Required Attendees\". 39. Field: \"Sent\" - default label is \"Sent\". 40. Field: \"ShowTimeAs\" - default label is \"Show Time As\". 41. Field: \"SpousePartner\" - default label is \"Spouse/Partner\". 42. Field: \"Start\" - default label is \"Start\". 43. Field: \"Subject\" - default label is \"Subject\". 44. Field: \"To\" - default label is \"To\". 45. Field: \"UserField1\" - default label is \"User Field 1\". 46. Field: \"UserField2\" - default label is \"User Field 2\". 47. Field: \"UserField3\" - default label is \"User Field 3\". 48. Field: \"UserField4\" - default label is \"User Field 4\".")
    public List<FieldLabel> getFieldLabels() {
        return this.fieldLabels;
    }

    public void setFieldLabels(List<FieldLabel> fieldLabels) {
        this.fieldLabels = fieldLabels;
    }

    public EmailOptions dateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        return this;
    }

    @ApiModelProperty(value="Time Format (can be include TimeZone) for example: 'MM d yyyy HH:mm tt', if not set - current system format is used")
    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public EmailOptions timeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
        return this;
    }

    @ApiModelProperty(value="Message time zone offset. Format should be compatible with .net TimeSpan")
    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailOptions emailOptions = (EmailOptions)o;
        return Objects.equals((Object)this.pageSize, (Object)emailOptions.pageSize) && Objects.equals(this.fieldLabels, emailOptions.fieldLabels) && Objects.equals(this.dateTimeFormat, emailOptions.dateTimeFormat) && Objects.equals(this.timeZoneOffset, emailOptions.timeZoneOffset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageSize, this.fieldLabels, this.dateTimeFormat, this.timeZoneOffset});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailOptions {\n");
        sb.append("    pageSize: ").append(this.toIndentedString((Object)this.pageSize)).append("\n");
        sb.append("    fieldLabels: ").append(this.toIndentedString(this.fieldLabels)).append("\n");
        sb.append("    dateTimeFormat: ").append(this.toIndentedString(this.dateTimeFormat)).append("\n");
        sb.append("    timeZoneOffset: ").append(this.toIndentedString(this.timeZoneOffset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageSizeEnum {
        UNSPECIFIED("Unspecified"),
        LETTER("Letter"),
        LEDGER("Ledger"),
        A0("A0"),
        A1("A1"),
        A2("A2"),
        A3("A3"),
        A4("A4");

        private String value;

        private PageSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageSizeEnum fromValue(String text) {
            for (PageSizeEnum b : PageSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageSizeEnum> {
            public void write(JsonWriter jsonWriter, PageSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

