/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.viewer.model.RenderOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Options for rendering document into HTML")
public class HtmlOptions
extends RenderOptions {
    @SerializedName(value="externalResources")
    private Boolean externalResources = null;
    @SerializedName(value="resourcePath")
    private String resourcePath = null;
    @SerializedName(value="isResponsive")
    private Boolean isResponsive = null;
    @SerializedName(value="minify")
    private Boolean minify = null;
    @SerializedName(value="excludeFonts")
    private Boolean excludeFonts = null;
    @SerializedName(value="fontsToExclude")
    private List<String> fontsToExclude = null;
    @SerializedName(value="forPrinting")
    private Boolean forPrinting = null;
    @SerializedName(value="imageHeight")
    private Integer imageHeight = null;
    @SerializedName(value="imageWidth")
    private Integer imageWidth = null;
    @SerializedName(value="imageMaxHeight")
    private Integer imageMaxHeight = null;
    @SerializedName(value="imageMaxWidth")
    private Integer imageMaxWidth = null;
    @SerializedName(value="renderToSinglePage")
    private Boolean renderToSinglePage = null;
    @SerializedName(value="removeJavaScript")
    private Boolean removeJavaScript = null;

    public HtmlOptions externalResources(Boolean externalResources) {
        this.externalResources = externalResources;
        return this;
    }

    @ApiModelProperty(required=true, value="Controls output HTML document resources (styles, images and fonts) linking. By default this option is disabled and all the resources are embedded into HTML document.")
    public Boolean getExternalResources() {
        return this.externalResources;
    }

    public void setExternalResources(Boolean externalResources) {
        this.externalResources = externalResources;
    }

    public HtmlOptions resourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    @ApiModelProperty(value="Path for the HTML resources (styles, images and fonts). For example when resource path is http://example.com/api/pages/{page-number}/resources/{resource-name} the {page-number} and {resource-name} templates will be replaced with page number and resource name accordingly. This option is ignored when ExternalResources option is disabled.")
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public HtmlOptions isResponsive(Boolean isResponsive) {
        this.isResponsive = isResponsive;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether rendering will provide responsive web pages, that look well on different device types. Default value is false.")
    public Boolean getIsResponsive() {
        return this.isResponsive;
    }

    public void setIsResponsive(Boolean isResponsive) {
        this.isResponsive = isResponsive;
    }

    public HtmlOptions minify(Boolean minify) {
        this.minify = minify;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables HTML content and HTML resources minification")
    public Boolean getMinify() {
        return this.minify;
    }

    public void setMinify(Boolean minify) {
        this.minify = minify;
    }

    public HtmlOptions excludeFonts(Boolean excludeFonts) {
        this.excludeFonts = excludeFonts;
        return this;
    }

    @ApiModelProperty(required=true, value="When enabled prevents adding any fonts into HTML document             ")
    public Boolean getExcludeFonts() {
        return this.excludeFonts;
    }

    public void setExcludeFonts(Boolean excludeFonts) {
        this.excludeFonts = excludeFonts;
    }

    public HtmlOptions fontsToExclude(List<String> fontsToExclude) {
        this.fontsToExclude = fontsToExclude;
        return this;
    }

    public HtmlOptions addFontsToExcludeItem(String fontsToExcludeItem) {
        if (this.fontsToExclude == null) {
            this.fontsToExclude = new ArrayList<String>();
        }
        this.fontsToExclude.add(fontsToExcludeItem);
        return this;
    }

    @ApiModelProperty(value="This option is supported for presentations only. The list of font names, to exclude from HTML document             ")
    public List<String> getFontsToExclude() {
        return this.fontsToExclude;
    }

    public void setFontsToExclude(List<String> fontsToExclude) {
        this.fontsToExclude = fontsToExclude;
    }

    public HtmlOptions forPrinting(Boolean forPrinting) {
        this.forPrinting = forPrinting;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether to optimize output HTML for printing.")
    public Boolean getForPrinting() {
        return this.forPrinting;
    }

    public void setForPrinting(Boolean forPrinting) {
        this.forPrinting = forPrinting;
    }

    public HtmlOptions imageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="The height of an output image in pixels. (When converting single image to HTML only)")
    public Integer getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
    }

    public HtmlOptions imageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
        return this;
    }

    @ApiModelProperty(required=true, value="The width of the output image in pixels. (When converting single image to HTML only)")
    public Integer getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
    }

    public HtmlOptions imageMaxHeight(Integer imageMaxHeight) {
        this.imageMaxHeight = imageMaxHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="Max height of an output image in pixels. (When converting single image to HTML only)")
    public Integer getImageMaxHeight() {
        return this.imageMaxHeight;
    }

    public void setImageMaxHeight(Integer imageMaxHeight) {
        this.imageMaxHeight = imageMaxHeight;
    }

    public HtmlOptions imageMaxWidth(Integer imageMaxWidth) {
        this.imageMaxWidth = imageMaxWidth;
        return this;
    }

    @ApiModelProperty(required=true, value="Max width of an output image in pixels. (When converting single image to HTML only)")
    public Integer getImageMaxWidth() {
        return this.imageMaxWidth;
    }

    public void setImageMaxWidth(Integer imageMaxWidth) {
        this.imageMaxWidth = imageMaxWidth;
    }

    public HtmlOptions renderToSinglePage(Boolean renderToSinglePage) {
        this.renderToSinglePage = renderToSinglePage;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables HTML content will be rendered to single page")
    public Boolean getRenderToSinglePage() {
        return this.renderToSinglePage;
    }

    public void setRenderToSinglePage(Boolean renderToSinglePage) {
        this.renderToSinglePage = renderToSinglePage;
    }

    public HtmlOptions removeJavaScript(Boolean removeJavaScript) {
        this.removeJavaScript = removeJavaScript;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to remove the JavaScript source code from the links in resultant HTML documents, when rendering input documents, which have the scripts. By default is enabled (true).             ")
    public Boolean getRemoveJavaScript() {
        return this.removeJavaScript;
    }

    public void setRemoveJavaScript(Boolean removeJavaScript) {
        this.removeJavaScript = removeJavaScript;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HtmlOptions htmlOptions = (HtmlOptions)o;
        return Objects.equals(this.externalResources, htmlOptions.externalResources) && Objects.equals(this.resourcePath, htmlOptions.resourcePath) && Objects.equals(this.isResponsive, htmlOptions.isResponsive) && Objects.equals(this.minify, htmlOptions.minify) && Objects.equals(this.excludeFonts, htmlOptions.excludeFonts) && Objects.equals(this.fontsToExclude, htmlOptions.fontsToExclude) && Objects.equals(this.forPrinting, htmlOptions.forPrinting) && Objects.equals(this.imageHeight, htmlOptions.imageHeight) && Objects.equals(this.imageWidth, htmlOptions.imageWidth) && Objects.equals(this.imageMaxHeight, htmlOptions.imageMaxHeight) && Objects.equals(this.imageMaxWidth, htmlOptions.imageMaxWidth) && Objects.equals(this.renderToSinglePage, htmlOptions.renderToSinglePage) && Objects.equals(this.removeJavaScript, htmlOptions.removeJavaScript) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.externalResources, this.resourcePath, this.isResponsive, this.minify, this.excludeFonts, this.fontsToExclude, this.forPrinting, this.imageHeight, this.imageWidth, this.imageMaxHeight, this.imageMaxWidth, this.renderToSinglePage, this.removeJavaScript, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HtmlOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    externalResources: ").append(this.toIndentedString(this.externalResources)).append("\n");
        sb.append("    resourcePath: ").append(this.toIndentedString(this.resourcePath)).append("\n");
        sb.append("    isResponsive: ").append(this.toIndentedString(this.isResponsive)).append("\n");
        sb.append("    minify: ").append(this.toIndentedString(this.minify)).append("\n");
        sb.append("    excludeFonts: ").append(this.toIndentedString(this.excludeFonts)).append("\n");
        sb.append("    fontsToExclude: ").append(this.toIndentedString(this.fontsToExclude)).append("\n");
        sb.append("    forPrinting: ").append(this.toIndentedString(this.forPrinting)).append("\n");
        sb.append("    imageHeight: ").append(this.toIndentedString(this.imageHeight)).append("\n");
        sb.append("    imageWidth: ").append(this.toIndentedString(this.imageWidth)).append("\n");
        sb.append("    imageMaxHeight: ").append(this.toIndentedString(this.imageMaxHeight)).append("\n");
        sb.append("    imageMaxWidth: ").append(this.toIndentedString(this.imageMaxWidth)).append("\n");
        sb.append("    renderToSinglePage: ").append(this.toIndentedString(this.renderToSinglePage)).append("\n");
        sb.append("    removeJavaScript: ").append(this.toIndentedString(this.removeJavaScript)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

