/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.viewer.model.RenderOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Options for rendering document into image")
public class ImageOptions
extends RenderOptions {
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="extractText")
    private Boolean extractText = null;
    @SerializedName(value="jpegQuality")
    private Integer jpegQuality = null;
    @SerializedName(value="maxWidth")
    private Integer maxWidth = null;
    @SerializedName(value="maxHeight")
    private Integer maxHeight = null;

    public ImageOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to specify output image width.  Specify image width in case when you want to change output image dimensions. When Width has value and Height value is 0 then Height value will be calculated  to save image proportions. ")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public ImageOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to specify output image height.  Specify image height in case when you want to change output image dimensions. When Height has value and Width value is 0 then Width value will be calculated  to save image proportions.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public ImageOptions extractText(Boolean extractText) {
        this.extractText = extractText;
        return this;
    }

    @ApiModelProperty(required=true, value="When enabled Viewer will extract text when it's possible (e.g. raster formats don't have text layer) and return it in the viewing result. This option might be useful when you want to add selectable text layer over the image. ")
    public Boolean getExtractText() {
        return this.extractText;
    }

    public void setExtractText(Boolean extractText) {
        this.extractText = extractText;
    }

    public ImageOptions jpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to specify quality when rendering as JPG. Valid values are between 1 and 100.  Default value is 90.")
    public Integer getJpegQuality() {
        return this.jpegQuality;
    }

    public void setJpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    public ImageOptions maxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    @ApiModelProperty(required=true, value="Max width of an output image in pixels")
    public Integer getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public ImageOptions maxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="Max height of an output image in pixels")
    public Integer getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageOptions imageOptions = (ImageOptions)o;
        return Objects.equals(this.width, imageOptions.width) && Objects.equals(this.height, imageOptions.height) && Objects.equals(this.extractText, imageOptions.extractText) && Objects.equals(this.jpegQuality, imageOptions.jpegQuality) && Objects.equals(this.maxWidth, imageOptions.maxWidth) && Objects.equals(this.maxHeight, imageOptions.maxHeight) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.width, this.height, this.extractText, this.jpegQuality, this.maxWidth, this.maxHeight, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    extractText: ").append(this.toIndentedString(this.extractText)).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.jpegQuality)).append("\n");
        sb.append("    maxWidth: ").append(this.toIndentedString(this.maxWidth)).append("\n");
        sb.append("    maxHeight: ").append(this.toIndentedString(this.maxHeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

