/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Provides options for rendering Mail storage (Lotus Notes, MBox) data files.")
public class MailStorageOptions {
    @SerializedName(value="textFilter")
    private String textFilter = null;
    @SerializedName(value="addressFilter")
    private String addressFilter = null;
    @SerializedName(value="maxItems")
    private Integer maxItems = null;

    public MailStorageOptions textFilter(String textFilter) {
        this.textFilter = textFilter;
        return this;
    }

    @ApiModelProperty(value="The keywords used to filter messages.")
    public String getTextFilter() {
        return this.textFilter;
    }

    public void setTextFilter(String textFilter) {
        this.textFilter = textFilter;
    }

    public MailStorageOptions addressFilter(String addressFilter) {
        this.addressFilter = addressFilter;
        return this;
    }

    @ApiModelProperty(value="The email-address used to filter messages by sender or recipient.")
    public String getAddressFilter() {
        return this.addressFilter;
    }

    public void setAddressFilter(String addressFilter) {
        this.addressFilter = addressFilter;
    }

    public MailStorageOptions maxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    @ApiModelProperty(required=true, value="The maximum number of messages or items for render. Default value is 0 - all messages will be rendered")
    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailStorageOptions mailStorageOptions = (MailStorageOptions)o;
        return Objects.equals(this.textFilter, mailStorageOptions.textFilter) && Objects.equals(this.addressFilter, mailStorageOptions.addressFilter) && Objects.equals(this.maxItems, mailStorageOptions.maxItems);
    }

    public int hashCode() {
        return Objects.hash(this.textFilter, this.addressFilter, this.maxItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MailStorageOptions {\n");
        sb.append("    textFilter: ").append(this.toIndentedString(this.textFilter)).append("\n");
        sb.append("    addressFilter: ").append(this.toIndentedString(this.addressFilter)).append("\n");
        sb.append("    maxItems: ").append(this.toIndentedString(this.maxItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

