/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Provides options for rendering Outlook data files")
public class OutlookOptions {
    @SerializedName(value="folder")
    private String folder = null;
    @SerializedName(value="textFilter")
    private String textFilter = null;
    @SerializedName(value="addressFilter")
    private String addressFilter = null;
    @SerializedName(value="maxItemsInFolder")
    private Integer maxItemsInFolder = null;

    public OutlookOptions folder(String folder) {
        this.folder = folder;
        return this;
    }

    @ApiModelProperty(value="The name of the folder (e.g. Inbox, Sent Item or Deleted Items) to render")
    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public OutlookOptions textFilter(String textFilter) {
        this.textFilter = textFilter;
        return this;
    }

    @ApiModelProperty(value="The keywords used to filter messages")
    public String getTextFilter() {
        return this.textFilter;
    }

    public void setTextFilter(String textFilter) {
        this.textFilter = textFilter;
    }

    public OutlookOptions addressFilter(String addressFilter) {
        this.addressFilter = addressFilter;
        return this;
    }

    @ApiModelProperty(value="The email-address used to filter messages by sender or recipient")
    public String getAddressFilter() {
        return this.addressFilter;
    }

    public void setAddressFilter(String addressFilter) {
        this.addressFilter = addressFilter;
    }

    public OutlookOptions maxItemsInFolder(Integer maxItemsInFolder) {
        this.maxItemsInFolder = maxItemsInFolder;
        return this;
    }

    @ApiModelProperty(required=true, value="The maximum number of messages or items, that can be rendered from one folder")
    public Integer getMaxItemsInFolder() {
        return this.maxItemsInFolder;
    }

    public void setMaxItemsInFolder(Integer maxItemsInFolder) {
        this.maxItemsInFolder = maxItemsInFolder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlookOptions outlookOptions = (OutlookOptions)o;
        return Objects.equals(this.folder, outlookOptions.folder) && Objects.equals(this.textFilter, outlookOptions.textFilter) && Objects.equals(this.addressFilter, outlookOptions.addressFilter) && Objects.equals(this.maxItemsInFolder, outlookOptions.maxItemsInFolder);
    }

    public int hashCode() {
        return Objects.hash(this.folder, this.textFilter, this.addressFilter, this.maxItemsInFolder);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutlookOptions {\n");
        sb.append("    folder: ").append(this.toIndentedString(this.folder)).append("\n");
        sb.append("    textFilter: ").append(this.toIndentedString(this.textFilter)).append("\n");
        sb.append("    addressFilter: ").append(this.toIndentedString(this.addressFilter)).append("\n");
        sb.append("    maxItemsInFolder: ").append(this.toIndentedString(this.maxItemsInFolder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

