/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.viewer.model.Line;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Page information")
public class PageInfo {
    @SerializedName(value="number")
    private Integer number = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="visible")
    private Boolean visible = null;
    @SerializedName(value="lines")
    private List<Line> lines = null;

    public PageInfo number(Integer number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(required=true, value="The page number")
    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public PageInfo width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="The width of the page in pixels when viewing as JPG or PNG")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public PageInfo height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="The height of the page in pixels when viewing as JPG or PNG")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public PageInfo visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @ApiModelProperty(required=true, value="The page visibility indicator")
    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public PageInfo lines(List<Line> lines) {
        this.lines = lines;
        return this;
    }

    public PageInfo addLinesItem(Line linesItem) {
        if (this.lines == null) {
            this.lines = new ArrayList<Line>();
        }
        this.lines.add(linesItem);
        return this;
    }

    @ApiModelProperty(value="The lines contained by the page when viewing as JPG or PNG with enabled Text Extraction")
    public List<Line> getLines() {
        return this.lines;
    }

    public void setLines(List<Line> lines) {
        this.lines = lines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageInfo pageInfo = (PageInfo)o;
        return Objects.equals(this.number, pageInfo.number) && Objects.equals(this.width, pageInfo.width) && Objects.equals(this.height, pageInfo.height) && Objects.equals(this.visible, pageInfo.visible) && Objects.equals(this.lines, pageInfo.lines);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.width, this.height, this.visible, this.lines);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageInfo {\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("    lines: ").append(this.toIndentedString(this.lines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

