/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Clockwise page rotation ")
public class PageRotation {
    @SerializedName(value="pageNumber")
    private Integer pageNumber = null;
    @SerializedName(value="rotationAngle")
    private RotationAngleEnum rotationAngle = null;

    public PageRotation pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Page number to rotate")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public PageRotation rotationAngle(RotationAngleEnum rotationAngle) {
        this.rotationAngle = rotationAngle;
        return this;
    }

    @ApiModelProperty(required=true, value="Rotation angle")
    public RotationAngleEnum getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(RotationAngleEnum rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageRotation pageRotation = (PageRotation)o;
        return Objects.equals(this.pageNumber, pageRotation.pageNumber) && Objects.equals((Object)this.rotationAngle, (Object)pageRotation.rotationAngle);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageNumber, this.rotationAngle});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageRotation {\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    rotationAngle: ").append(this.toIndentedString((Object)this.rotationAngle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RotationAngleEnum {
        ON90DEGREE("On90Degree"),
        ON180DEGREE("On180Degree"),
        ON270DEGREE("On270Degree");

        private String value;

        private RotationAngleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RotationAngleEnum fromValue(String text) {
            for (RotationAngleEnum b : RotationAngleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RotationAngleEnum> {
            public void write(JsonWriter jsonWriter, RotationAngleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RotationAngleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RotationAngleEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

