/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Provides options for rendering PDF documents")
public class PdfDocumentOptions {
    @SerializedName(value="disableCharsGrouping")
    private Boolean disableCharsGrouping = null;
    @SerializedName(value="enableLayeredRendering")
    private Boolean enableLayeredRendering = null;
    @SerializedName(value="enableFontHinting")
    private Boolean enableFontHinting = null;
    @SerializedName(value="renderOriginalPageSize")
    private Boolean renderOriginalPageSize = null;
    @SerializedName(value="imageQuality")
    private ImageQualityEnum imageQuality = null;
    @SerializedName(value="renderTextAsImage")
    private Boolean renderTextAsImage = null;
    @SerializedName(value="fixedLayout")
    private Boolean fixedLayout = null;
    @SerializedName(value="wrapImagesInSvg")
    private Boolean wrapImagesInSvg = null;
    @SerializedName(value="disableFontLicenseVerifications")
    private Boolean disableFontLicenseVerifications = null;

    public PdfDocumentOptions disableCharsGrouping(Boolean disableCharsGrouping) {
        this.disableCharsGrouping = disableCharsGrouping;
        return this;
    }

    @ApiModelProperty(required=true, value="Disables chars grouping to keep maximum precision during chars positioning when rendering the page")
    public Boolean getDisableCharsGrouping() {
        return this.disableCharsGrouping;
    }

    public void setDisableCharsGrouping(Boolean disableCharsGrouping) {
        this.disableCharsGrouping = disableCharsGrouping;
    }

    public PdfDocumentOptions enableLayeredRendering(Boolean enableLayeredRendering) {
        this.enableLayeredRendering = enableLayeredRendering;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables rendering of text and graphics according to z-order in original PDF document  when rendering into HTML")
    public Boolean getEnableLayeredRendering() {
        return this.enableLayeredRendering;
    }

    public void setEnableLayeredRendering(Boolean enableLayeredRendering) {
        this.enableLayeredRendering = enableLayeredRendering;
    }

    public PdfDocumentOptions enableFontHinting(Boolean enableFontHinting) {
        this.enableFontHinting = enableFontHinting;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables font hinting. The font hinting adjusts the display of an outline font. Supported only for TTF fonts when these fonts are used in source document.")
    public Boolean getEnableFontHinting() {
        return this.enableFontHinting;
    }

    public void setEnableFontHinting(Boolean enableFontHinting) {
        this.enableFontHinting = enableFontHinting;
    }

    public PdfDocumentOptions renderOriginalPageSize(Boolean renderOriginalPageSize) {
        this.renderOriginalPageSize = renderOriginalPageSize;
        return this;
    }

    @ApiModelProperty(required=true, value="When this option enabled the output pages will have the same size in pixels as page size in a source PDF document. By default GroupDocs.Viewer calculates output image page size for better rendering quality. This option is supported when rendering into PNG or JPG formats.")
    public Boolean getRenderOriginalPageSize() {
        return this.renderOriginalPageSize;
    }

    public void setRenderOriginalPageSize(Boolean renderOriginalPageSize) {
        this.renderOriginalPageSize = renderOriginalPageSize;
    }

    public PdfDocumentOptions imageQuality(ImageQualityEnum imageQuality) {
        this.imageQuality = imageQuality;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies output image quality for image resources when rendering into HTML. The default value is Low")
    public ImageQualityEnum getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(ImageQualityEnum imageQuality) {
        this.imageQuality = imageQuality;
    }

    public PdfDocumentOptions renderTextAsImage(Boolean renderTextAsImage) {
        this.renderTextAsImage = renderTextAsImage;
        return this;
    }

    @ApiModelProperty(required=true, value="When this option is set to true, the text is rendered as an image in the output HTML. Enable this option to make text unselectable or to fix characters rendering and make HTML look like PDF. The default value is false. This option is supported when rendering into HTML.")
    public Boolean getRenderTextAsImage() {
        return this.renderTextAsImage;
    }

    public void setRenderTextAsImage(Boolean renderTextAsImage) {
        this.renderTextAsImage = renderTextAsImage;
    }

    public PdfDocumentOptions fixedLayout(Boolean fixedLayout) {
        this.fixedLayout = fixedLayout;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables rendering the PDF and EPUB documents to HTML with a fixed layout.")
    public Boolean getFixedLayout() {
        return this.fixedLayout;
    }

    public void setFixedLayout(Boolean fixedLayout) {
        this.fixedLayout = fixedLayout;
    }

    public PdfDocumentOptions wrapImagesInSvg(Boolean wrapImagesInSvg) {
        this.wrapImagesInSvg = wrapImagesInSvg;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables wrapping each image in the output HTML document in SVG tag to improve the output quality.")
    public Boolean getWrapImagesInSvg() {
        return this.wrapImagesInSvg;
    }

    public void setWrapImagesInSvg(Boolean wrapImagesInSvg) {
        this.wrapImagesInSvg = wrapImagesInSvg;
    }

    public PdfDocumentOptions disableFontLicenseVerifications(Boolean disableFontLicenseVerifications) {
        this.disableFontLicenseVerifications = disableFontLicenseVerifications;
        return this;
    }

    @ApiModelProperty(required=true, value="Disables any license restrictions for all fonts in the current XPS/OXPS document.")
    public Boolean getDisableFontLicenseVerifications() {
        return this.disableFontLicenseVerifications;
    }

    public void setDisableFontLicenseVerifications(Boolean disableFontLicenseVerifications) {
        this.disableFontLicenseVerifications = disableFontLicenseVerifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfDocumentOptions pdfDocumentOptions = (PdfDocumentOptions)o;
        return Objects.equals(this.disableCharsGrouping, pdfDocumentOptions.disableCharsGrouping) && Objects.equals(this.enableLayeredRendering, pdfDocumentOptions.enableLayeredRendering) && Objects.equals(this.enableFontHinting, pdfDocumentOptions.enableFontHinting) && Objects.equals(this.renderOriginalPageSize, pdfDocumentOptions.renderOriginalPageSize) && Objects.equals((Object)this.imageQuality, (Object)pdfDocumentOptions.imageQuality) && Objects.equals(this.renderTextAsImage, pdfDocumentOptions.renderTextAsImage) && Objects.equals(this.fixedLayout, pdfDocumentOptions.fixedLayout) && Objects.equals(this.wrapImagesInSvg, pdfDocumentOptions.wrapImagesInSvg) && Objects.equals(this.disableFontLicenseVerifications, pdfDocumentOptions.disableFontLicenseVerifications);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.disableCharsGrouping, this.enableLayeredRendering, this.enableFontHinting, this.renderOriginalPageSize, this.imageQuality, this.renderTextAsImage, this.fixedLayout, this.wrapImagesInSvg, this.disableFontLicenseVerifications});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfDocumentOptions {\n");
        sb.append("    disableCharsGrouping: ").append(this.toIndentedString(this.disableCharsGrouping)).append("\n");
        sb.append("    enableLayeredRendering: ").append(this.toIndentedString(this.enableLayeredRendering)).append("\n");
        sb.append("    enableFontHinting: ").append(this.toIndentedString(this.enableFontHinting)).append("\n");
        sb.append("    renderOriginalPageSize: ").append(this.toIndentedString(this.renderOriginalPageSize)).append("\n");
        sb.append("    imageQuality: ").append(this.toIndentedString((Object)this.imageQuality)).append("\n");
        sb.append("    renderTextAsImage: ").append(this.toIndentedString(this.renderTextAsImage)).append("\n");
        sb.append("    fixedLayout: ").append(this.toIndentedString(this.fixedLayout)).append("\n");
        sb.append("    wrapImagesInSvg: ").append(this.toIndentedString(this.wrapImagesInSvg)).append("\n");
        sb.append("    disableFontLicenseVerifications: ").append(this.toIndentedString(this.disableFontLicenseVerifications)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ImageQualityEnum {
        LOW("Low"),
        MEDIUM("Medium"),
        HIGH("High");

        private String value;

        private ImageQualityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ImageQualityEnum fromValue(String text) {
            for (ImageQualityEnum b : ImageQualityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ImageQualityEnum> {
            public void write(JsonWriter jsonWriter, ImageQualityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ImageQualityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ImageQualityEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

