/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains the PDF optimization options to apply to the output PDF file.")
public class PdfOptimizationOptions {
    @SerializedName(value="lineriaze")
    private Boolean lineriaze = null;
    @SerializedName(value="removeAnnotations")
    private Boolean removeAnnotations = null;
    @SerializedName(value="removeFormFields")
    private Boolean removeFormFields = null;
    @SerializedName(value="convertToGrayScale")
    private Boolean convertToGrayScale = null;
    @SerializedName(value="subsetFonts")
    private Boolean subsetFonts = null;
    @SerializedName(value="compressImages")
    private Boolean compressImages = null;
    @SerializedName(value="imageQuality")
    private Integer imageQuality = null;
    @SerializedName(value="resizeImages")
    private Boolean resizeImages = null;
    @SerializedName(value="maxResolution")
    private Integer maxResolution = null;
    @SerializedName(value="optimizeSpreadsheets")
    private Boolean optimizeSpreadsheets = null;

    public PdfOptimizationOptions lineriaze(Boolean lineriaze) {
        this.lineriaze = lineriaze;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables optimization the output PDF file for viewing online with a web browser. This optimization allows a browser to display the first pages of a PDF file when     you open the document, instead of waiting for the entire file to download.")
    public Boolean getLineriaze() {
        return this.lineriaze;
    }

    public void setLineriaze(Boolean lineriaze) {
        this.lineriaze = lineriaze;
    }

    public PdfOptimizationOptions removeAnnotations(Boolean removeAnnotations) {
        this.removeAnnotations = removeAnnotations;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables removing annotation from the output PDF file.")
    public Boolean getRemoveAnnotations() {
        return this.removeAnnotations;
    }

    public void setRemoveAnnotations(Boolean removeAnnotations) {
        this.removeAnnotations = removeAnnotations;
    }

    public PdfOptimizationOptions removeFormFields(Boolean removeFormFields) {
        this.removeFormFields = removeFormFields;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables removing form fields from a PDF file.")
    public Boolean getRemoveFormFields() {
        return this.removeFormFields;
    }

    public void setRemoveFormFields(Boolean removeFormFields) {
        this.removeFormFields = removeFormFields;
    }

    public PdfOptimizationOptions convertToGrayScale(Boolean convertToGrayScale) {
        this.convertToGrayScale = convertToGrayScale;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables converting the output PDF file to a grayscale.")
    public Boolean getConvertToGrayScale() {
        return this.convertToGrayScale;
    }

    public void setConvertToGrayScale(Boolean convertToGrayScale) {
        this.convertToGrayScale = convertToGrayScale;
    }

    public PdfOptimizationOptions subsetFonts(Boolean subsetFonts) {
        this.subsetFonts = subsetFonts;
        return this;
    }

    @ApiModelProperty(required=true, value="Subsets fonts in the output PDF file. If the file uses embedded fonts, it contains all font data. GroupDocs.Viewer can subset embedded fonts to reduce the file size.")
    public Boolean getSubsetFonts() {
        return this.subsetFonts;
    }

    public void setSubsetFonts(Boolean subsetFonts) {
        this.subsetFonts = subsetFonts;
    }

    public PdfOptimizationOptions compressImages(Boolean compressImages) {
        this.compressImages = compressImages;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables compressing images in the output PDF file. Use this option to allow other compressing options: PdfOptimizationOptions.ImageQuality and PdfOptimizationOptions.MaxResolution.")
    public Boolean getCompressImages() {
        return this.compressImages;
    }

    public void setCompressImages(Boolean compressImages) {
        this.compressImages = compressImages;
    }

    public PdfOptimizationOptions imageQuality(Integer imageQuality) {
        this.imageQuality = imageQuality;
        return this;
    }

    @ApiModelProperty(required=true, value="Sets the image quality in the output PDF file (in percent). To change the image quality, first set the PdfOptimizationOptions.CompressImages property to true.")
    public Integer getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(Integer imageQuality) {
        this.imageQuality = imageQuality;
    }

    public PdfOptimizationOptions resizeImages(Boolean resizeImages) {
        this.resizeImages = resizeImages;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables setting the maximum resolution in the output PDF file. To allow this option, set the GroupDocs.Viewer.Options.PdfOptimizationOptions.CompressImages property to true. This option allows setting the GroupDocs.Viewer.Options.PdfOptimizationOptions.MaxResolution property.")
    public Boolean getResizeImages() {
        return this.resizeImages;
    }

    public void setResizeImages(Boolean resizeImages) {
        this.resizeImages = resizeImages;
    }

    public PdfOptimizationOptions maxResolution(Integer maxResolution) {
        this.maxResolution = maxResolution;
        return this;
    }

    @ApiModelProperty(required=true, value="Sets the maximum resolution in the output PDF file. To allow this option, set the GroupDocs.Viewer.Options.PdfOptimizationOptions.CompressImages and GroupDocs.Viewer.Options.PdfOptimizationOptions.MaxResolution properties to true. The default value is 300.")
    public Integer getMaxResolution() {
        return this.maxResolution;
    }

    public void setMaxResolution(Integer maxResolution) {
        this.maxResolution = maxResolution;
    }

    public PdfOptimizationOptions optimizeSpreadsheets(Boolean optimizeSpreadsheets) {
        this.optimizeSpreadsheets = optimizeSpreadsheets;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables optimization of spreadsheets in the PDF files. This optimization allows to reduce the output file size by setting up border lines. Besides that, it removes the Arial and Times New Roman characters of 32-127 codes.")
    public Boolean getOptimizeSpreadsheets() {
        return this.optimizeSpreadsheets;
    }

    public void setOptimizeSpreadsheets(Boolean optimizeSpreadsheets) {
        this.optimizeSpreadsheets = optimizeSpreadsheets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfOptimizationOptions pdfOptimizationOptions = (PdfOptimizationOptions)o;
        return Objects.equals(this.lineriaze, pdfOptimizationOptions.lineriaze) && Objects.equals(this.removeAnnotations, pdfOptimizationOptions.removeAnnotations) && Objects.equals(this.removeFormFields, pdfOptimizationOptions.removeFormFields) && Objects.equals(this.convertToGrayScale, pdfOptimizationOptions.convertToGrayScale) && Objects.equals(this.subsetFonts, pdfOptimizationOptions.subsetFonts) && Objects.equals(this.compressImages, pdfOptimizationOptions.compressImages) && Objects.equals(this.imageQuality, pdfOptimizationOptions.imageQuality) && Objects.equals(this.resizeImages, pdfOptimizationOptions.resizeImages) && Objects.equals(this.maxResolution, pdfOptimizationOptions.maxResolution) && Objects.equals(this.optimizeSpreadsheets, pdfOptimizationOptions.optimizeSpreadsheets);
    }

    public int hashCode() {
        return Objects.hash(this.lineriaze, this.removeAnnotations, this.removeFormFields, this.convertToGrayScale, this.subsetFonts, this.compressImages, this.imageQuality, this.resizeImages, this.maxResolution, this.optimizeSpreadsheets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfOptimizationOptions {\n");
        sb.append("    lineriaze: ").append(this.toIndentedString(this.lineriaze)).append("\n");
        sb.append("    removeAnnotations: ").append(this.toIndentedString(this.removeAnnotations)).append("\n");
        sb.append("    removeFormFields: ").append(this.toIndentedString(this.removeFormFields)).append("\n");
        sb.append("    convertToGrayScale: ").append(this.toIndentedString(this.convertToGrayScale)).append("\n");
        sb.append("    subsetFonts: ").append(this.toIndentedString(this.subsetFonts)).append("\n");
        sb.append("    compressImages: ").append(this.toIndentedString(this.compressImages)).append("\n");
        sb.append("    imageQuality: ").append(this.toIndentedString(this.imageQuality)).append("\n");
        sb.append("    resizeImages: ").append(this.toIndentedString(this.resizeImages)).append("\n");
        sb.append("    maxResolution: ").append(this.toIndentedString(this.maxResolution)).append("\n");
        sb.append("    optimizeSpreadsheets: ").append(this.toIndentedString(this.optimizeSpreadsheets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

