/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.viewer.model.PdfOptimizationOptions;
import com.groupdocs.cloud.viewer.model.RenderOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Options for rendering document into PDF")
public class PdfOptions
extends RenderOptions {
    @SerializedName(value="documentOpenPassword")
    private String documentOpenPassword = null;
    @SerializedName(value="permissionsPassword")
    private String permissionsPassword = null;
    @SerializedName(value="permissions")
    private List<String> permissions = null;
    @SerializedName(value="pdfOptimizationOptions")
    private PdfOptimizationOptions pdfOptimizationOptions = null;
    @SerializedName(value="imageMaxWidth")
    private Integer imageMaxWidth = null;
    @SerializedName(value="imageMaxHeight")
    private Integer imageMaxHeight = null;
    @SerializedName(value="imageWidth")
    private Integer imageWidth = null;
    @SerializedName(value="imageHeight")
    private Integer imageHeight = null;

    public PdfOptions documentOpenPassword(String documentOpenPassword) {
        this.documentOpenPassword = documentOpenPassword;
        return this;
    }

    @ApiModelProperty(value="The password required to open the PDF document")
    public String getDocumentOpenPassword() {
        return this.documentOpenPassword;
    }

    public void setDocumentOpenPassword(String documentOpenPassword) {
        this.documentOpenPassword = documentOpenPassword;
    }

    public PdfOptions permissionsPassword(String permissionsPassword) {
        this.permissionsPassword = permissionsPassword;
        return this;
    }

    @ApiModelProperty(value="The password required to change permission settings; Using a permissions password  you can restrict printing, modification and data extraction")
    public String getPermissionsPassword() {
        return this.permissionsPassword;
    }

    public void setPermissionsPassword(String permissionsPassword) {
        this.permissionsPassword = permissionsPassword;
    }

    public PdfOptions permissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public PdfOptions addPermissionsItem(String permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(value="The array of PDF document permissions. Allowed values are: AllowAll, DenyPrinting, DenyModification, DenyDataExtraction, DenyAll Default value is AllowAll, if now permissions are set.")
    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public PdfOptions pdfOptimizationOptions(PdfOptimizationOptions pdfOptimizationOptions) {
        this.pdfOptimizationOptions = pdfOptimizationOptions;
        return this;
    }

    @ApiModelProperty(value="Contains options for rendering documents into PDF format.")
    public PdfOptimizationOptions getPdfOptimizationOptions() {
        return this.pdfOptimizationOptions;
    }

    public void setPdfOptimizationOptions(PdfOptimizationOptions pdfOptimizationOptions) {
        this.pdfOptimizationOptions = pdfOptimizationOptions;
    }

    public PdfOptions imageMaxWidth(Integer imageMaxWidth) {
        this.imageMaxWidth = imageMaxWidth;
        return this;
    }

    @ApiModelProperty(required=true, value="Max width of an output image in pixels. (When converting single image to PDF only)")
    public Integer getImageMaxWidth() {
        return this.imageMaxWidth;
    }

    public void setImageMaxWidth(Integer imageMaxWidth) {
        this.imageMaxWidth = imageMaxWidth;
    }

    public PdfOptions imageMaxHeight(Integer imageMaxHeight) {
        this.imageMaxHeight = imageMaxHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="Max height of an output image in pixels. (When converting single image to PDF only)")
    public Integer getImageMaxHeight() {
        return this.imageMaxHeight;
    }

    public void setImageMaxHeight(Integer imageMaxHeight) {
        this.imageMaxHeight = imageMaxHeight;
    }

    public PdfOptions imageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
        return this;
    }

    @ApiModelProperty(required=true, value="The width of the output image in pixels. (When converting single image to PDF only)")
    public Integer getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
    }

    public PdfOptions imageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="The height of an output image in pixels. (When converting single image to PDF only)")
    public Integer getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfOptions pdfOptions = (PdfOptions)o;
        return Objects.equals(this.documentOpenPassword, pdfOptions.documentOpenPassword) && Objects.equals(this.permissionsPassword, pdfOptions.permissionsPassword) && Objects.equals(this.permissions, pdfOptions.permissions) && Objects.equals(this.pdfOptimizationOptions, pdfOptions.pdfOptimizationOptions) && Objects.equals(this.imageMaxWidth, pdfOptions.imageMaxWidth) && Objects.equals(this.imageMaxHeight, pdfOptions.imageMaxHeight) && Objects.equals(this.imageWidth, pdfOptions.imageWidth) && Objects.equals(this.imageHeight, pdfOptions.imageHeight) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.documentOpenPassword, this.permissionsPassword, this.permissions, this.pdfOptimizationOptions, this.imageMaxWidth, this.imageMaxHeight, this.imageWidth, this.imageHeight, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    documentOpenPassword: ").append(this.toIndentedString(this.documentOpenPassword)).append("\n");
        sb.append("    permissionsPassword: ").append(this.toIndentedString(this.permissionsPassword)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    pdfOptimizationOptions: ").append(this.toIndentedString(this.pdfOptimizationOptions)).append("\n");
        sb.append("    imageMaxWidth: ").append(this.toIndentedString(this.imageMaxWidth)).append("\n");
        sb.append("    imageMaxHeight: ").append(this.toIndentedString(this.imageMaxHeight)).append("\n");
        sb.append("    imageWidth: ").append(this.toIndentedString(this.imageWidth)).append("\n");
        sb.append("    imageHeight: ").append(this.toIndentedString(this.imageHeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

