/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Rendering options for Project file formats. Project file formats include files with extensions: .mpt, .mpp")
public class ProjectManagementOptions {
    @SerializedName(value="pageSize")
    private PageSizeEnum pageSize = null;
    @SerializedName(value="timeUnit")
    private TimeUnitEnum timeUnit = null;
    @SerializedName(value="startDate")
    private OffsetDateTime startDate = null;
    @SerializedName(value="endDate")
    private OffsetDateTime endDate = null;

    public ProjectManagementOptions pageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(required=true, value="The size of the page.")
    public PageSizeEnum getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
    }

    public ProjectManagementOptions timeUnit(TimeUnitEnum timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    @ApiModelProperty(required=true, value="The time unit to use as minimal point.")
    public TimeUnitEnum getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnitEnum timeUnit) {
        this.timeUnit = timeUnit;
    }

    public ProjectManagementOptions startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The start date of a Gantt Chart View to render.        ")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public ProjectManagementOptions endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The end date of a Gantt Chart View to render.")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectManagementOptions projectManagementOptions = (ProjectManagementOptions)o;
        return Objects.equals((Object)this.pageSize, (Object)projectManagementOptions.pageSize) && Objects.equals((Object)this.timeUnit, (Object)projectManagementOptions.timeUnit) && Objects.equals(this.startDate, projectManagementOptions.startDate) && Objects.equals(this.endDate, projectManagementOptions.endDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageSize, this.timeUnit, this.startDate, this.endDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectManagementOptions {\n");
        sb.append("    pageSize: ").append(this.toIndentedString((Object)this.pageSize)).append("\n");
        sb.append("    timeUnit: ").append(this.toIndentedString((Object)this.timeUnit)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TimeUnitEnum {
        UNSPECIFIED("Unspecified"),
        DAYS("Days"),
        THIRDSOFMONTHS("ThirdsOfMonths"),
        MONTHS("Months");

        private String value;

        private TimeUnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TimeUnitEnum fromValue(String text) {
            for (TimeUnitEnum b : TimeUnitEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TimeUnitEnum> {
            public void write(JsonWriter jsonWriter, TimeUnitEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TimeUnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TimeUnitEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageSizeEnum {
        UNSPECIFIED("Unspecified"),
        LETTER("Letter"),
        LEDGER("Ledger"),
        A0("A0"),
        A1("A1"),
        A2("A2"),
        A3("A3"),
        A4("A4");

        private String value;

        private PageSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageSizeEnum fromValue(String text) {
            for (PageSizeEnum b : PageSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageSizeEnum> {
            public void write(JsonWriter jsonWriter, PageSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

