/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Represents view information for MS Project document")
public class ProjectManagementViewInfo {
    @SerializedName(value="startDate")
    private OffsetDateTime startDate = null;
    @SerializedName(value="endDate")
    private OffsetDateTime endDate = null;

    public ProjectManagementViewInfo startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date time from which the project started")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public ProjectManagementViewInfo endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date time when the project is to be completed")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectManagementViewInfo projectManagementViewInfo = (ProjectManagementViewInfo)o;
        return Objects.equals(this.startDate, projectManagementViewInfo.startDate) && Objects.equals(this.endDate, projectManagementViewInfo.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectManagementViewInfo {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

