/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.viewer.model.ArchiveOptions;
import com.groupdocs.cloud.viewer.model.CadOptions;
import com.groupdocs.cloud.viewer.model.EmailOptions;
import com.groupdocs.cloud.viewer.model.MailStorageOptions;
import com.groupdocs.cloud.viewer.model.OutlookOptions;
import com.groupdocs.cloud.viewer.model.PageRotation;
import com.groupdocs.cloud.viewer.model.PdfDocumentOptions;
import com.groupdocs.cloud.viewer.model.ProjectManagementOptions;
import com.groupdocs.cloud.viewer.model.SpreadsheetOptions;
import com.groupdocs.cloud.viewer.model.TextOptions;
import com.groupdocs.cloud.viewer.model.VisioRenderingOptions;
import com.groupdocs.cloud.viewer.model.WebDocumentOptions;
import com.groupdocs.cloud.viewer.model.WordProcessingOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Rendering options")
public class RenderOptions {
    @SerializedName(value="startPageNumber")
    private Integer startPageNumber = null;
    @SerializedName(value="countPagesToRender")
    private Integer countPagesToRender = null;
    @SerializedName(value="pagesToRender")
    private List<Integer> pagesToRender = null;
    @SerializedName(value="pageRotations")
    private List<PageRotation> pageRotations = null;
    @SerializedName(value="defaultFontName")
    private String defaultFontName = null;
    @SerializedName(value="defaultEncoding")
    private String defaultEncoding = null;
    @SerializedName(value="detectEncoding")
    private Boolean detectEncoding = null;
    @SerializedName(value="renderComments")
    private Boolean renderComments = null;
    @SerializedName(value="renderNotes")
    private Boolean renderNotes = null;
    @SerializedName(value="renderHiddenPages")
    private Boolean renderHiddenPages = null;
    @SerializedName(value="spreadsheetOptions")
    private SpreadsheetOptions spreadsheetOptions = null;
    @SerializedName(value="cadOptions")
    private CadOptions cadOptions = null;
    @SerializedName(value="emailOptions")
    private EmailOptions emailOptions = null;
    @SerializedName(value="projectManagementOptions")
    private ProjectManagementOptions projectManagementOptions = null;
    @SerializedName(value="pdfDocumentOptions")
    private PdfDocumentOptions pdfDocumentOptions = null;
    @SerializedName(value="wordProcessingOptions")
    private WordProcessingOptions wordProcessingOptions = null;
    @SerializedName(value="outlookOptions")
    private OutlookOptions outlookOptions = null;
    @SerializedName(value="archiveOptions")
    private ArchiveOptions archiveOptions = null;
    @SerializedName(value="textOptions")
    private TextOptions textOptions = null;
    @SerializedName(value="mailStorageOptions")
    private MailStorageOptions mailStorageOptions = null;
    @SerializedName(value="visioRenderingOptions")
    private VisioRenderingOptions visioRenderingOptions = null;
    @SerializedName(value="webDocumentOptions")
    private WebDocumentOptions webDocumentOptions = null;

    public RenderOptions startPageNumber(Integer startPageNumber) {
        this.startPageNumber = startPageNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Page number from which rendering should be started")
    public Integer getStartPageNumber() {
        return this.startPageNumber;
    }

    public void setStartPageNumber(Integer startPageNumber) {
        this.startPageNumber = startPageNumber;
    }

    public RenderOptions countPagesToRender(Integer countPagesToRender) {
        this.countPagesToRender = countPagesToRender;
        return this;
    }

    @ApiModelProperty(required=true, value="Count pages which should be rendered")
    public Integer getCountPagesToRender() {
        return this.countPagesToRender;
    }

    public void setCountPagesToRender(Integer countPagesToRender) {
        this.countPagesToRender = countPagesToRender;
    }

    public RenderOptions pagesToRender(List<Integer> pagesToRender) {
        this.pagesToRender = pagesToRender;
        return this;
    }

    public RenderOptions addPagesToRenderItem(Integer pagesToRenderItem) {
        if (this.pagesToRender == null) {
            this.pagesToRender = new ArrayList<Integer>();
        }
        this.pagesToRender.add(pagesToRenderItem);
        return this;
    }

    @ApiModelProperty(value="Pages list to render. Ignored, if StartPageNumber and CountPagesToRender are provided")
    public List<Integer> getPagesToRender() {
        return this.pagesToRender;
    }

    public void setPagesToRender(List<Integer> pagesToRender) {
        this.pagesToRender = pagesToRender;
    }

    public RenderOptions pageRotations(List<PageRotation> pageRotations) {
        this.pageRotations = pageRotations;
        return this;
    }

    public RenderOptions addPageRotationsItem(PageRotation pageRotationsItem) {
        if (this.pageRotations == null) {
            this.pageRotations = new ArrayList<PageRotation>();
        }
        this.pageRotations.add(pageRotationsItem);
        return this;
    }

    @ApiModelProperty(value="Page rotations")
    public List<PageRotation> getPageRotations() {
        return this.pageRotations;
    }

    public void setPageRotations(List<PageRotation> pageRotations) {
        this.pageRotations = pageRotations;
    }

    public RenderOptions defaultFontName(String defaultFontName) {
        this.defaultFontName = defaultFontName;
        return this;
    }

    @ApiModelProperty(value="Default font name may be specified in following cases: - You want to generally specify the default font to fall back on, if particular font   in the document cannot be found during rendering. - Your document uses fonts, that contain non-English characters and you want to make sure   any missing font is replaced with one that has the same character set available.")
    public String getDefaultFontName() {
        return this.defaultFontName;
    }

    public void setDefaultFontName(String defaultFontName) {
        this.defaultFontName = defaultFontName;
    }

    public RenderOptions defaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    @ApiModelProperty(value="Default encoding for the plain text files such as .csv, .txt and .eml files when encoding is not specified in header")
    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public RenderOptions detectEncoding(Boolean detectEncoding) {
        this.detectEncoding = detectEncoding;
        return this;
    }

    @ApiModelProperty(value="This option enables TXT, TSV, and CSV files encoding detection. In case the encoding can't be detected the DefaultEncoding is used.")
    public Boolean getDetectEncoding() {
        return this.detectEncoding;
    }

    public void setDetectEncoding(Boolean detectEncoding) {
        this.detectEncoding = detectEncoding;
    }

    public RenderOptions renderComments(Boolean renderComments) {
        this.renderComments = renderComments;
        return this;
    }

    @ApiModelProperty(required=true, value="When enabled comments will be rendered to the output")
    public Boolean getRenderComments() {
        return this.renderComments;
    }

    public void setRenderComments(Boolean renderComments) {
        this.renderComments = renderComments;
    }

    public RenderOptions renderNotes(Boolean renderNotes) {
        this.renderNotes = renderNotes;
        return this;
    }

    @ApiModelProperty(required=true, value="When enabled notes will be rendered to the output")
    public Boolean getRenderNotes() {
        return this.renderNotes;
    }

    public void setRenderNotes(Boolean renderNotes) {
        this.renderNotes = renderNotes;
    }

    public RenderOptions renderHiddenPages(Boolean renderHiddenPages) {
        this.renderHiddenPages = renderHiddenPages;
        return this;
    }

    @ApiModelProperty(required=true, value="When enabled hidden pages, sheets or slides will be rendered to the output")
    public Boolean getRenderHiddenPages() {
        return this.renderHiddenPages;
    }

    public void setRenderHiddenPages(Boolean renderHiddenPages) {
        this.renderHiddenPages = renderHiddenPages;
    }

    public RenderOptions spreadsheetOptions(SpreadsheetOptions spreadsheetOptions) {
        this.spreadsheetOptions = spreadsheetOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for Spreadsheet source file formats Spreadsheet file formats include files with extensions: .xls, .xlsx, .xlsm, .xlsb, .csv, .ods, .ots, .xltx, .xltm, .tsv ")
    public SpreadsheetOptions getSpreadsheetOptions() {
        return this.spreadsheetOptions;
    }

    public void setSpreadsheetOptions(SpreadsheetOptions spreadsheetOptions) {
        this.spreadsheetOptions = spreadsheetOptions;
    }

    public RenderOptions cadOptions(CadOptions cadOptions) {
        this.cadOptions = cadOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for CAD source file formats CAD file formats include files with extensions: .dwg, .dxf, .dgn, .ifc, .stl")
    public CadOptions getCadOptions() {
        return this.cadOptions;
    }

    public void setCadOptions(CadOptions cadOptions) {
        this.cadOptions = cadOptions;
    }

    public RenderOptions emailOptions(EmailOptions emailOptions) {
        this.emailOptions = emailOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for Email source file formats Email file formats include files with extensions: .msg, .eml, .emlx, .ifc, .stl")
    public EmailOptions getEmailOptions() {
        return this.emailOptions;
    }

    public void setEmailOptions(EmailOptions emailOptions) {
        this.emailOptions = emailOptions;
    }

    public RenderOptions projectManagementOptions(ProjectManagementOptions projectManagementOptions) {
        this.projectManagementOptions = projectManagementOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for MS Project source file formats Project file formats include files with extensions: .mpt, .mpp")
    public ProjectManagementOptions getProjectManagementOptions() {
        return this.projectManagementOptions;
    }

    public void setProjectManagementOptions(ProjectManagementOptions projectManagementOptions) {
        this.projectManagementOptions = projectManagementOptions;
    }

    public RenderOptions pdfDocumentOptions(PdfDocumentOptions pdfDocumentOptions) {
        this.pdfDocumentOptions = pdfDocumentOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for PDF source file formats")
    public PdfDocumentOptions getPdfDocumentOptions() {
        return this.pdfDocumentOptions;
    }

    public void setPdfDocumentOptions(PdfDocumentOptions pdfDocumentOptions) {
        this.pdfDocumentOptions = pdfDocumentOptions;
    }

    public RenderOptions wordProcessingOptions(WordProcessingOptions wordProcessingOptions) {
        this.wordProcessingOptions = wordProcessingOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for WordProcessing source file formats")
    public WordProcessingOptions getWordProcessingOptions() {
        return this.wordProcessingOptions;
    }

    public void setWordProcessingOptions(WordProcessingOptions wordProcessingOptions) {
        this.wordProcessingOptions = wordProcessingOptions;
    }

    public RenderOptions outlookOptions(OutlookOptions outlookOptions) {
        this.outlookOptions = outlookOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for Outlook source file formats")
    public OutlookOptions getOutlookOptions() {
        return this.outlookOptions;
    }

    public void setOutlookOptions(OutlookOptions outlookOptions) {
        this.outlookOptions = outlookOptions;
    }

    public RenderOptions archiveOptions(ArchiveOptions archiveOptions) {
        this.archiveOptions = archiveOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for Archive source file formats")
    public ArchiveOptions getArchiveOptions() {
        return this.archiveOptions;
    }

    public void setArchiveOptions(ArchiveOptions archiveOptions) {
        this.archiveOptions = archiveOptions;
    }

    public RenderOptions textOptions(TextOptions textOptions) {
        this.textOptions = textOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for Text source file formats")
    public TextOptions getTextOptions() {
        return this.textOptions;
    }

    public void setTextOptions(TextOptions textOptions) {
        this.textOptions = textOptions;
    }

    public RenderOptions mailStorageOptions(MailStorageOptions mailStorageOptions) {
        this.mailStorageOptions = mailStorageOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for Mail storage (Lotus Notes, MBox) data files.")
    public MailStorageOptions getMailStorageOptions() {
        return this.mailStorageOptions;
    }

    public void setMailStorageOptions(MailStorageOptions mailStorageOptions) {
        this.mailStorageOptions = mailStorageOptions;
    }

    public RenderOptions visioRenderingOptions(VisioRenderingOptions visioRenderingOptions) {
        this.visioRenderingOptions = visioRenderingOptions;
        return this;
    }

    @ApiModelProperty(value="Rendering options for Visio source file formats")
    public VisioRenderingOptions getVisioRenderingOptions() {
        return this.visioRenderingOptions;
    }

    public void setVisioRenderingOptions(VisioRenderingOptions visioRenderingOptions) {
        this.visioRenderingOptions = visioRenderingOptions;
    }

    public RenderOptions webDocumentOptions(WebDocumentOptions webDocumentOptions) {
        this.webDocumentOptions = webDocumentOptions;
        return this;
    }

    @ApiModelProperty(value="This rendering options enables you to customize the appearance of the output HTML/PDF/PNG/JPEG when rendering Web documents.")
    public WebDocumentOptions getWebDocumentOptions() {
        return this.webDocumentOptions;
    }

    public void setWebDocumentOptions(WebDocumentOptions webDocumentOptions) {
        this.webDocumentOptions = webDocumentOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderOptions renderOptions = (RenderOptions)o;
        return Objects.equals(this.startPageNumber, renderOptions.startPageNumber) && Objects.equals(this.countPagesToRender, renderOptions.countPagesToRender) && Objects.equals(this.pagesToRender, renderOptions.pagesToRender) && Objects.equals(this.pageRotations, renderOptions.pageRotations) && Objects.equals(this.defaultFontName, renderOptions.defaultFontName) && Objects.equals(this.defaultEncoding, renderOptions.defaultEncoding) && Objects.equals(this.detectEncoding, renderOptions.detectEncoding) && Objects.equals(this.renderComments, renderOptions.renderComments) && Objects.equals(this.renderNotes, renderOptions.renderNotes) && Objects.equals(this.renderHiddenPages, renderOptions.renderHiddenPages) && Objects.equals(this.spreadsheetOptions, renderOptions.spreadsheetOptions) && Objects.equals(this.cadOptions, renderOptions.cadOptions) && Objects.equals(this.emailOptions, renderOptions.emailOptions) && Objects.equals(this.projectManagementOptions, renderOptions.projectManagementOptions) && Objects.equals(this.pdfDocumentOptions, renderOptions.pdfDocumentOptions) && Objects.equals(this.wordProcessingOptions, renderOptions.wordProcessingOptions) && Objects.equals(this.outlookOptions, renderOptions.outlookOptions) && Objects.equals(this.archiveOptions, renderOptions.archiveOptions) && Objects.equals(this.textOptions, renderOptions.textOptions) && Objects.equals(this.mailStorageOptions, renderOptions.mailStorageOptions) && Objects.equals(this.visioRenderingOptions, renderOptions.visioRenderingOptions) && Objects.equals(this.webDocumentOptions, renderOptions.webDocumentOptions);
    }

    public int hashCode() {
        return Objects.hash(this.startPageNumber, this.countPagesToRender, this.pagesToRender, this.pageRotations, this.defaultFontName, this.defaultEncoding, this.detectEncoding, this.renderComments, this.renderNotes, this.renderHiddenPages, this.spreadsheetOptions, this.cadOptions, this.emailOptions, this.projectManagementOptions, this.pdfDocumentOptions, this.wordProcessingOptions, this.outlookOptions, this.archiveOptions, this.textOptions, this.mailStorageOptions, this.visioRenderingOptions, this.webDocumentOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RenderOptions {\n");
        sb.append("    startPageNumber: ").append(this.toIndentedString(this.startPageNumber)).append("\n");
        sb.append("    countPagesToRender: ").append(this.toIndentedString(this.countPagesToRender)).append("\n");
        sb.append("    pagesToRender: ").append(this.toIndentedString(this.pagesToRender)).append("\n");
        sb.append("    pageRotations: ").append(this.toIndentedString(this.pageRotations)).append("\n");
        sb.append("    defaultFontName: ").append(this.toIndentedString(this.defaultFontName)).append("\n");
        sb.append("    defaultEncoding: ").append(this.toIndentedString(this.defaultEncoding)).append("\n");
        sb.append("    detectEncoding: ").append(this.toIndentedString(this.detectEncoding)).append("\n");
        sb.append("    renderComments: ").append(this.toIndentedString(this.renderComments)).append("\n");
        sb.append("    renderNotes: ").append(this.toIndentedString(this.renderNotes)).append("\n");
        sb.append("    renderHiddenPages: ").append(this.toIndentedString(this.renderHiddenPages)).append("\n");
        sb.append("    spreadsheetOptions: ").append(this.toIndentedString(this.spreadsheetOptions)).append("\n");
        sb.append("    cadOptions: ").append(this.toIndentedString(this.cadOptions)).append("\n");
        sb.append("    emailOptions: ").append(this.toIndentedString(this.emailOptions)).append("\n");
        sb.append("    projectManagementOptions: ").append(this.toIndentedString(this.projectManagementOptions)).append("\n");
        sb.append("    pdfDocumentOptions: ").append(this.toIndentedString(this.pdfDocumentOptions)).append("\n");
        sb.append("    wordProcessingOptions: ").append(this.toIndentedString(this.wordProcessingOptions)).append("\n");
        sb.append("    outlookOptions: ").append(this.toIndentedString(this.outlookOptions)).append("\n");
        sb.append("    archiveOptions: ").append(this.toIndentedString(this.archiveOptions)).append("\n");
        sb.append("    textOptions: ").append(this.toIndentedString(this.textOptions)).append("\n");
        sb.append("    mailStorageOptions: ").append(this.toIndentedString(this.mailStorageOptions)).append("\n");
        sb.append("    visioRenderingOptions: ").append(this.toIndentedString(this.visioRenderingOptions)).append("\n");
        sb.append("    webDocumentOptions: ").append(this.toIndentedString(this.webDocumentOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

