/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Rendering options for Spreadsheet file formats. Spreadsheet file formats include files with extensions: .xls, .xlsx, .xlsm, .xlsb, .csv, .ods, .ots, .xltx, .xltm, .tsv ")
public class SpreadsheetOptions {
    @SerializedName(value="paginateSheets")
    private Boolean paginateSheets = null;
    @SerializedName(value="countRowsPerPage")
    private Integer countRowsPerPage = null;
    @SerializedName(value="countColumnsPerPage")
    private Integer countColumnsPerPage = null;
    @SerializedName(value="renderGridLines")
    private Boolean renderGridLines = null;
    @SerializedName(value="renderEmptyRows")
    private Boolean renderEmptyRows = null;
    @SerializedName(value="renderEmptyColumns")
    private Boolean renderEmptyColumns = null;
    @SerializedName(value="renderHiddenRows")
    private Boolean renderHiddenRows = null;
    @SerializedName(value="renderHiddenColumns")
    private Boolean renderHiddenColumns = null;
    @SerializedName(value="renderHeadings")
    private Boolean renderHeadings = null;
    @SerializedName(value="renderPrintAreaOnly")
    private Boolean renderPrintAreaOnly = null;
    @SerializedName(value="textOverflowMode")
    private TextOverflowModeEnum textOverflowMode = null;

    public SpreadsheetOptions paginateSheets(Boolean paginateSheets) {
        this.paginateSheets = paginateSheets;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to enable worksheets pagination. By default one worksheet is rendered into one page.")
    public Boolean getPaginateSheets() {
        return this.paginateSheets;
    }

    public void setPaginateSheets(Boolean paginateSheets) {
        this.paginateSheets = paginateSheets;
    }

    public SpreadsheetOptions countRowsPerPage(Integer countRowsPerPage) {
        this.countRowsPerPage = countRowsPerPage;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of rows rendered into one page when PaginateSheets is enabled. Default value is 50.")
    public Integer getCountRowsPerPage() {
        return this.countRowsPerPage;
    }

    public void setCountRowsPerPage(Integer countRowsPerPage) {
        this.countRowsPerPage = countRowsPerPage;
    }

    public SpreadsheetOptions countColumnsPerPage(Integer countColumnsPerPage) {
        this.countColumnsPerPage = countColumnsPerPage;
        return this;
    }

    @ApiModelProperty(required=true, value="The columns count to include into each page when splitting worksheet into pages.")
    public Integer getCountColumnsPerPage() {
        return this.countColumnsPerPage;
    }

    public void setCountColumnsPerPage(Integer countColumnsPerPage) {
        this.countColumnsPerPage = countColumnsPerPage;
    }

    public SpreadsheetOptions renderGridLines(Boolean renderGridLines) {
        this.renderGridLines = renderGridLines;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether to render grid lines")
    public Boolean getRenderGridLines() {
        return this.renderGridLines;
    }

    public void setRenderGridLines(Boolean renderGridLines) {
        this.renderGridLines = renderGridLines;
    }

    public SpreadsheetOptions renderEmptyRows(Boolean renderEmptyRows) {
        this.renderEmptyRows = renderEmptyRows;
        return this;
    }

    @ApiModelProperty(required=true, value="By default empty rows are skipped. Enable this option in case you want to render empty rows.")
    public Boolean getRenderEmptyRows() {
        return this.renderEmptyRows;
    }

    public void setRenderEmptyRows(Boolean renderEmptyRows) {
        this.renderEmptyRows = renderEmptyRows;
    }

    public SpreadsheetOptions renderEmptyColumns(Boolean renderEmptyColumns) {
        this.renderEmptyColumns = renderEmptyColumns;
        return this;
    }

    @ApiModelProperty(required=true, value="By default empty columns are skipped. Enable this option in case you want to render empty columns.")
    public Boolean getRenderEmptyColumns() {
        return this.renderEmptyColumns;
    }

    public void setRenderEmptyColumns(Boolean renderEmptyColumns) {
        this.renderEmptyColumns = renderEmptyColumns;
    }

    public SpreadsheetOptions renderHiddenRows(Boolean renderHiddenRows) {
        this.renderHiddenRows = renderHiddenRows;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables rendering of hidden rows.")
    public Boolean getRenderHiddenRows() {
        return this.renderHiddenRows;
    }

    public void setRenderHiddenRows(Boolean renderHiddenRows) {
        this.renderHiddenRows = renderHiddenRows;
    }

    public SpreadsheetOptions renderHiddenColumns(Boolean renderHiddenColumns) {
        this.renderHiddenColumns = renderHiddenColumns;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables rendering of hidden columns.")
    public Boolean getRenderHiddenColumns() {
        return this.renderHiddenColumns;
    }

    public void setRenderHiddenColumns(Boolean renderHiddenColumns) {
        this.renderHiddenColumns = renderHiddenColumns;
    }

    public SpreadsheetOptions renderHeadings(Boolean renderHeadings) {
        this.renderHeadings = renderHeadings;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables headings rendering.")
    public Boolean getRenderHeadings() {
        return this.renderHeadings;
    }

    public void setRenderHeadings(Boolean renderHeadings) {
        this.renderHeadings = renderHeadings;
    }

    public SpreadsheetOptions renderPrintAreaOnly(Boolean renderPrintAreaOnly) {
        this.renderPrintAreaOnly = renderPrintAreaOnly;
        return this;
    }

    @ApiModelProperty(required=true, value="Enables rendering worksheet(s) sections which is defined as print area. Renders each print area in a worksheet as a separate page.")
    public Boolean getRenderPrintAreaOnly() {
        return this.renderPrintAreaOnly;
    }

    public void setRenderPrintAreaOnly(Boolean renderPrintAreaOnly) {
        this.renderPrintAreaOnly = renderPrintAreaOnly;
    }

    public SpreadsheetOptions textOverflowMode(TextOverflowModeEnum textOverflowMode) {
        this.textOverflowMode = textOverflowMode;
        return this;
    }

    @ApiModelProperty(required=true, value="The text overflow mode for rendering spreadsheet documents into HTML")
    public TextOverflowModeEnum getTextOverflowMode() {
        return this.textOverflowMode;
    }

    public void setTextOverflowMode(TextOverflowModeEnum textOverflowMode) {
        this.textOverflowMode = textOverflowMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpreadsheetOptions spreadsheetOptions = (SpreadsheetOptions)o;
        return Objects.equals(this.paginateSheets, spreadsheetOptions.paginateSheets) && Objects.equals(this.countRowsPerPage, spreadsheetOptions.countRowsPerPage) && Objects.equals(this.countColumnsPerPage, spreadsheetOptions.countColumnsPerPage) && Objects.equals(this.renderGridLines, spreadsheetOptions.renderGridLines) && Objects.equals(this.renderEmptyRows, spreadsheetOptions.renderEmptyRows) && Objects.equals(this.renderEmptyColumns, spreadsheetOptions.renderEmptyColumns) && Objects.equals(this.renderHiddenRows, spreadsheetOptions.renderHiddenRows) && Objects.equals(this.renderHiddenColumns, spreadsheetOptions.renderHiddenColumns) && Objects.equals(this.renderHeadings, spreadsheetOptions.renderHeadings) && Objects.equals(this.renderPrintAreaOnly, spreadsheetOptions.renderPrintAreaOnly) && Objects.equals((Object)this.textOverflowMode, (Object)spreadsheetOptions.textOverflowMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paginateSheets, this.countRowsPerPage, this.countColumnsPerPage, this.renderGridLines, this.renderEmptyRows, this.renderEmptyColumns, this.renderHiddenRows, this.renderHiddenColumns, this.renderHeadings, this.renderPrintAreaOnly, this.textOverflowMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpreadsheetOptions {\n");
        sb.append("    paginateSheets: ").append(this.toIndentedString(this.paginateSheets)).append("\n");
        sb.append("    countRowsPerPage: ").append(this.toIndentedString(this.countRowsPerPage)).append("\n");
        sb.append("    countColumnsPerPage: ").append(this.toIndentedString(this.countColumnsPerPage)).append("\n");
        sb.append("    renderGridLines: ").append(this.toIndentedString(this.renderGridLines)).append("\n");
        sb.append("    renderEmptyRows: ").append(this.toIndentedString(this.renderEmptyRows)).append("\n");
        sb.append("    renderEmptyColumns: ").append(this.toIndentedString(this.renderEmptyColumns)).append("\n");
        sb.append("    renderHiddenRows: ").append(this.toIndentedString(this.renderHiddenRows)).append("\n");
        sb.append("    renderHiddenColumns: ").append(this.toIndentedString(this.renderHiddenColumns)).append("\n");
        sb.append("    renderHeadings: ").append(this.toIndentedString(this.renderHeadings)).append("\n");
        sb.append("    renderPrintAreaOnly: ").append(this.toIndentedString(this.renderPrintAreaOnly)).append("\n");
        sb.append("    textOverflowMode: ").append(this.toIndentedString((Object)this.textOverflowMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextOverflowModeEnum {
        OVERLAY("Overlay"),
        OVERLAYIFNEXTISEMPTY("OverlayIfNextIsEmpty"),
        AUTOFITCOLUMN("AutoFitColumn"),
        HIDETEXT("HideText");

        private String value;

        private TextOverflowModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextOverflowModeEnum fromValue(String text) {
            for (TextOverflowModeEnum b : TextOverflowModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextOverflowModeEnum> {
            public void write(JsonWriter jsonWriter, TextOverflowModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextOverflowModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextOverflowModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

