/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.viewer.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Text element")
public class TextElement {
    @SerializedName(value="x")
    private Double X = null;
    @SerializedName(value="y")
    private Double Y = null;
    @SerializedName(value="width")
    private Double width = null;
    @SerializedName(value="height")
    private Double height = null;
    @SerializedName(value="value")
    private String value = null;

    public TextElement X(Double X) {
        this.X = X;
        return this;
    }

    @ApiModelProperty(required=true, value="The X coordinate of the highest left point on the page layout where the rectangle that contains element begins.             ")
    public Double getX() {
        return this.X;
    }

    public void setX(Double X) {
        this.X = X;
    }

    public TextElement Y(Double Y) {
        this.Y = Y;
        return this;
    }

    @ApiModelProperty(required=true, value="The Y coordinate of the highest left point on the page layout where the rectangle that contains element begins.             ")
    public Double getY() {
        return this.Y;
    }

    public void setY(Double Y) {
        this.Y = Y;
    }

    public TextElement width(Double width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="The width of the rectangle which contains the element (in pixels).              ")
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public TextElement height(Double height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="The height of the rectangle which contains the element (in pixels).              ")
    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public TextElement value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The element value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextElement textElement = (TextElement)o;
        return Objects.equals(this.X, textElement.X) && Objects.equals(this.Y, textElement.Y) && Objects.equals(this.width, textElement.width) && Objects.equals(this.height, textElement.height) && Objects.equals(this.value, textElement.value);
    }

    public int hashCode() {
        return Objects.hash(this.X, this.Y, this.width, this.height, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextElement {\n");
        sb.append("    X: ").append(this.toIndentedString(this.X)).append("\n");
        sb.append("    Y: ").append(this.toIndentedString(this.Y)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

